/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.tenant;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.dyc.authority.model.tenant.ISysTenantModel;
import com.tydic.dyc.authority.model.tenant.SysTenantInfoDo;
import com.tydic.dyc.authority.model.tenant.qrybo.SysTenantApplicationRelQryBo;
import com.tydic.dyc.authority.model.tenant.qrybo.SysTenantInfoQryBo;
import com.tydic.dyc.authority.model.tenant.sub.SysApplicationSubDo;
import com.tydic.dyc.authority.service.tenant.AuthGetTenantApplicationListService;
import com.tydic.dyc.authority.service.tenant.bo.AuthGetTenantApplicationListReqBo;
import com.tydic.dyc.authority.service.tenant.bo.AuthGetTenantApplicationListRspBo;
import com.tydic.dyc.authority.service.tenant.bo.AuthTenantApplicationRelBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="authority_CENTER_DEV", serviceInterface=AuthGetTenantApplicationListService.class)
public class AuthGetTenantApplicationListServiceImpl
implements AuthGetTenantApplicationListService {
    @Autowired
    private ISysTenantModel iSysTenantModel;

    public AuthGetTenantApplicationListRspBo getTenantApplicationList(AuthGetTenantApplicationListReqBo reqBo) {
        AuthGetTenantApplicationListRspBo rspBo = AuthRu.success(AuthGetTenantApplicationListRspBo.class);
        this.validateArg(reqBo);
        SysTenantInfoQryBo qryBo = new SysTenantInfoQryBo();
        qryBo.setTenantId(reqBo.getTenantId());
        SysTenantInfoDo rspDoDetail = this.iSysTenantModel.getTenantInfoDetails(qryBo);
        if (rspDoDetail == null || rspDoDetail.getTenantId() == null) {
            throw new BaseBusinessException("100001", "\u672a\u67e5\u8be2\u5230\u79df\u6237\u4fe1\u606f");
        }
        SysTenantApplicationRelQryBo qryListDo = new SysTenantApplicationRelQryBo();
        qryListDo.setTenantId(reqBo.getTenantId());
        List<SysApplicationSubDo> rspDo = this.iSysTenantModel.getTenantApplicationRelList(qryListDo);
        List<AuthTenantApplicationRelBo> DoToBo = AuthRu.jsl(rspDo, AuthTenantApplicationRelBo.class);
        rspBo.setTenantApplicationBoList(DoToBo);
        return rspBo;
    }

    private void validateArg(AuthGetTenantApplicationListReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthCreateTenantInfoReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getTenantId() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[TenantId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

