/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.user;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.dyc.authority.model.user.ISysUserInfoModel;
import com.tydic.dyc.authority.model.user.qrybo.SysThirdBindQryBo;
import com.tydic.dyc.authority.model.user.sub.SysThirdBindSubDo;
import com.tydic.dyc.authority.service.user.AuthDeleteThirdBindService;
import com.tydic.dyc.authority.service.user.bo.AuthDeleteThirdBindReqBo;
import com.tydic.dyc.authority.service.user.bo.AuthDeleteThirdBindRspBo;
import com.tydic.dyc.authority.service.user.bo.AuthThirdBindBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="authority_CENTER_DEV", serviceInterface=AuthDeleteThirdBindService.class)
public class AuthDeleteThirdBindServiceImpl
implements AuthDeleteThirdBindService {
    @Autowired
    private ISysUserInfoModel iSysUserInfoModel;

    public AuthDeleteThirdBindRspBo deleteThirdBind(AuthDeleteThirdBindReqBo reqBo) {
        AuthDeleteThirdBindRspBo rspBo = AuthRu.success(AuthDeleteThirdBindRspBo.class);
        this.validateArg(reqBo);
        SysThirdBindSubDo reqDo = this.buildDoByBO(reqBo);
        SysThirdBindQryBo bindQryBo = AuthRu.js(reqBo, SysThirdBindQryBo.class);
        List<SysThirdBindSubDo> bindThirdList = this.iSysUserInfoModel.getThirdBindList(bindQryBo);
        if (CollectionUtils.isEmpty(bindThirdList)) {
            return rspBo;
        }
        SysThirdBindSubDo rspDo = this.iSysUserInfoModel.updateThirdBind(reqDo);
        AuthThirdBindBo DoToBo = AuthRu.js(rspDo, AuthThirdBindBo.class);
        rspBo.setThirdBindBo(DoToBo);
        return rspBo;
    }

    private SysThirdBindSubDo buildDoByBO(AuthDeleteThirdBindReqBo reqBo) {
        reqBo.setUpdateTime(reqBo.getUpdateTime());
        SysThirdBindSubDo reqDo = AuthRu.js(reqBo, SysThirdBindSubDo.class);
        reqDo.setDelFlag("1");
        return reqDo;
    }

    private void validateArg(AuthDeleteThirdBindReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthDeleteThirdBindReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getAuthId() != null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthIdId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getAuthType() != null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthType]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getCustId() != null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[custId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

