/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.user;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.dyc.authority.model.user.ISysUserInfoModel;
import com.tydic.dyc.authority.model.user.SysUserInfoDo;
import com.tydic.dyc.authority.model.user.qrybo.SysUserInfoQryBo;
import com.tydic.dyc.authority.service.user.AuthEnableUserInfoService;
import com.tydic.dyc.authority.service.user.bo.AuthEnableUserInfoReqBo;
import com.tydic.dyc.authority.service.user.bo.AuthEnableUserInfoRspBo;
import com.tydic.dyc.authority.service.user.bo.AuthUserInfoBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="authority_CENTER_DEV", serviceInterface=AuthEnableUserInfoService.class)
public class AuthEnableUserInfoServiceImpl
implements AuthEnableUserInfoService {
    @Autowired
    private ISysUserInfoModel iSysUserInfoModel;

    public AuthEnableUserInfoRspBo enableUserInfo(AuthEnableUserInfoReqBo reqBo) {
        AuthEnableUserInfoRspBo rspBo = AuthRu.success(AuthEnableUserInfoRspBo.class);
        this.validateArg(reqBo);
        SysUserInfoDo reqDo = this.buildDoByBO(reqBo);
        SysUserInfoQryBo qryBo = new SysUserInfoQryBo();
        qryBo.setUserId(reqBo.getUserId());
        SysUserInfoDo userInfoDo = this.iSysUserInfoModel.getUserInfoDetails(qryBo);
        if (userInfoDo == null || userInfoDo.getUserId() == null) {
            throw new BaseBusinessException("100001", "\u672a\u67e5\u8be2\u5230\u7528\u6237\u4fe1\u606f");
        }
        SysUserInfoDo rspDo = this.iSysUserInfoModel.modifyUserInfo(reqDo, qryBo);
        AuthUserInfoBo DoToBo = AuthRu.js(rspDo, AuthUserInfoBo.class);
        rspBo.setUserInfoBo(DoToBo);
        return rspBo;
    }

    private SysUserInfoDo buildDoByBO(AuthEnableUserInfoReqBo reqBo) {
        reqBo.setUpdateTime(reqBo.getUpdateTime());
        SysUserInfoDo reqDo = AuthRu.js(reqBo, SysUserInfoDo.class);
        reqDo.setUserStatus("1");
        return reqDo;
    }

    private void validateArg(AuthEnableUserInfoReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthEnableUserInfoReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getUserId() != null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[UserId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

