/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.user;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.dyc.authority.model.user.ISysUserInfoModel;
import com.tydic.dyc.authority.model.user.SysUserInfoDo;
import com.tydic.dyc.authority.model.user.qrybo.SysUserInfoQryBo;
import com.tydic.dyc.authority.service.organization.bo.AuthRoleInfoBo;
import com.tydic.dyc.authority.service.user.AuthGetUserRoleListService;
import com.tydic.dyc.authority.service.user.bo.AuthGetUserRoleListReqBo;
import com.tydic.dyc.authority.service.user.bo.AuthGetUserRoleListRspBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="authority_CENTER_DEV", serviceInterface=AuthGetUserRoleListService.class)
public class AuthGetUserRoleListServiceImpl
implements AuthGetUserRoleListService {
    @Autowired
    private ISysUserInfoModel iSysUserInfoModel;

    public AuthGetUserRoleListRspBo getUserRoleList(AuthGetUserRoleListReqBo reqBo) {
        AuthGetUserRoleListRspBo rspBo = AuthRu.success(AuthGetUserRoleListRspBo.class);
        this.validateArg(reqBo);
        SysUserInfoQryBo qryBo = new SysUserInfoQryBo();
        qryBo.setUserId(reqBo.getUserId());
        SysUserInfoDo rspDo = this.iSysUserInfoModel.getUserInfoDetails(qryBo);
        if (rspDo == null || rspDo.getUserId() == null) {
            throw new BaseBusinessException("100001", "\u672a\u67e5\u8be2\u5230\u7528\u6237\u4fe1\u606f");
        }
        SysUserInfoDo roleQryBo = new SysUserInfoDo();
        roleQryBo.setUserId(rspDo.getUserId());
        SysUserInfoDo roleInfoDo = this.iSysUserInfoModel.getRoleInfoListByUser(roleQryBo);
        List<AuthRoleInfoBo> roleBoList = AuthRu.jsl(roleInfoDo.getUserRoleList(), AuthRoleInfoBo.class);
        rspBo.setRoleInfoBoList(roleBoList);
        return rspBo;
    }

    private void validateArg(AuthGetUserRoleListReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthGetUserRoleListReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getUserId() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[UserId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

