/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.user;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.dyc.authority.constants.AuthDicConstant;
import com.tydic.dyc.authority.model.common.sub.SysAuthDistributeSubDo;
import com.tydic.dyc.authority.model.common.sub.SysRoleInfoSubDo;
import com.tydic.dyc.authority.model.user.ISysUserInfoModel;
import com.tydic.dyc.authority.model.user.SysUserInfoDo;
import com.tydic.dyc.authority.model.user.qrybo.SysUserInfoQryBo;
import com.tydic.dyc.authority.model.user.qrybo.SysUserTagRelQryBo;
import com.tydic.dyc.authority.model.user.sub.SysCustInfoSubDo;
import com.tydic.dyc.authority.model.user.sub.SysUserTagRelSubDo;
import com.tydic.dyc.authority.service.domainservice.bo.AuthDistributeBo;
import com.tydic.dyc.authority.service.user.AuthModifyUserInfoService;
import com.tydic.dyc.authority.service.user.bo.AuthModifyUserInfoReqBo;
import com.tydic.dyc.authority.service.user.bo.AuthModifyUserInfoRspBo;
import com.tydic.dyc.authority.service.user.bo.AuthUserInfoBo;
import com.tydic.dyc.authority.service.user.bo.AuthUserTagRelBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.authority.utils.IdUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="authority_CENTER_DEV", serviceInterface=AuthModifyUserInfoService.class)
public class AuthModifyUserInfoServiceImpl
implements AuthModifyUserInfoService {
    @Autowired
    private ISysUserInfoModel iSysUserInfoModel;

    public AuthModifyUserInfoRspBo AuthModifyUserInfo(AuthModifyUserInfoReqBo reqBo) {
        AuthModifyUserInfoRspBo rspBo = AuthRu.success(AuthModifyUserInfoRspBo.class);
        this.validateArg(reqBo);
        SysUserInfoQryBo qryBo = new SysUserInfoQryBo();
        qryBo.setUserId(reqBo.getUserId());
        SysUserInfoDo userInfoDo = this.iSysUserInfoModel.getUserInfoDetails(qryBo);
        if (userInfoDo == null || userInfoDo.getUserId() == null) {
            throw new BaseBusinessException("100001", "\u672a\u67e5\u8be2\u5230\u7528\u6237\u4fe1\u606f");
        }
        SysUserInfoDo reqDo = this.buildDoByBO(reqBo);
        SysUserInfoDo rspDo = this.iSysUserInfoModel.createUserInfo(reqDo);
        if (!CollectionUtils.isEmpty(reqDo.getAuthDistributeList())) {
            this.iSysUserInfoModel.addUserRoleList(reqDo);
        }
        if ("1".equals(reqBo.getIsChngTag())) {
            SysUserTagRelQryBo qryTagBo = new SysUserTagRelQryBo();
            qryTagBo.setUserId(reqBo.getUserId());
            List<SysUserTagRelSubDo> oldTagList = this.iSysUserInfoModel.getUserTagList(qryTagBo);
            List<SysUserTagRelSubDo> reqTagList = reqDo.getUserTagRelList();
            ArrayList<SysUserTagRelSubDo> equalsOldSubDo = new ArrayList<SysUserTagRelSubDo>();
            ArrayList<SysUserTagRelSubDo> equalsreqSubDo = new ArrayList<SysUserTagRelSubDo>();
            for (SysUserTagRelSubDo sysUserTagRelSubDo : oldTagList) {
                for (SysUserTagRelSubDo reqTagRelSubDo : reqDo.getUserTagRelList()) {
                    if (!sysUserTagRelSubDo.getTagId().equals(reqTagRelSubDo.getTagId())) continue;
                    equalsOldSubDo.add(sysUserTagRelSubDo);
                    equalsreqSubDo.add(reqTagRelSubDo);
                }
            }
            oldTagList.removeAll(equalsOldSubDo);
            reqTagList.removeAll(equalsreqSubDo);
            this.addUserTag(reqDo, reqTagList);
            this.deleteUserTag(reqDo, oldTagList);
        }
        if ("1".equals(reqBo.getIsChngAuthDistribute())) {
            SysUserInfoDo userRoleDo = this.iSysUserInfoModel.getRoleInfoListByUser(reqDo);
            List<SysRoleInfoSubDo> oldRoleList = userRoleDo.getUserRoleList();
            List<SysAuthDistributeSubDo> addSubDo = reqDo.getAuthDistributeList();
            ArrayList<SysAuthDistributeSubDo> eqaulsSubDo = new ArrayList<SysAuthDistributeSubDo>();
            ArrayList<SysRoleInfoSubDo> eqaulsRoleList = new ArrayList<SysRoleInfoSubDo>();
            block2: for (SysRoleInfoSubDo sysRoleInfoSubDo : oldRoleList) {
                for (SysAuthDistributeSubDo reqDistributeSubDo : addSubDo) {
                    if (!sysRoleInfoSubDo.getRoleId().equals(reqDistributeSubDo.getRoleId())) continue;
                    eqaulsSubDo.add(reqDistributeSubDo);
                    eqaulsRoleList.add(sysRoleInfoSubDo);
                    continue block2;
                }
            }
            oldRoleList.removeAll(eqaulsRoleList);
            addSubDo.removeAll(eqaulsSubDo);
            this.addUserRole(reqDo, addSubDo);
            this.deleteUserRole(reqDo, oldRoleList);
        }
        AuthUserInfoBo DoToBo = AuthRu.js(rspDo, AuthUserInfoBo.class);
        rspBo.setUserInfoBo(DoToBo);
        return rspBo;
    }

    private SysUserInfoDo buildDoByBO(AuthModifyUserInfoReqBo reqBo) {
        Serializable subDo;
        reqBo.setUpdateTime(new Date());
        SysUserInfoDo reqDo = AuthRu.js(reqBo, SysUserInfoDo.class);
        if (reqBo.getCustInfoBo() != null && reqBo.getCustId() == null) {
            SysCustInfoSubDo custSubDo = AuthRu.js(reqBo.getCustInfoBo(), SysCustInfoSubDo.class);
            custSubDo.setUpdateOperId(reqDo.getUpdateOperId());
            custSubDo.setUpdateOperName(reqDo.getUpdateOperName());
            custSubDo.setUpdateTime(reqDo.getUpdateTime());
            reqDo.setCustInfo(custSubDo);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getUserTagRelList())) {
            ArrayList<SysUserTagRelSubDo> sysUserTagRelList = new ArrayList<SysUserTagRelSubDo>();
            for (AuthUserTagRelBo bo : reqBo.getUserTagRelList()) {
                subDo = AuthRu.js(bo, SysUserTagRelSubDo.class);
                ((SysUserTagRelSubDo)subDo).setUpdateOperId(reqDo.getUpdateOperId());
                ((SysUserTagRelSubDo)subDo).setUpdateOperName(reqDo.getUpdateOperName());
                ((SysUserTagRelSubDo)subDo).setUpdateTime(reqDo.getUpdateTime());
                sysUserTagRelList.add((SysUserTagRelSubDo)subDo);
            }
            reqDo.setUserTagRelList(sysUserTagRelList);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getAuthDistributeList())) {
            ArrayList<SysAuthDistributeSubDo> authDistributeList = new ArrayList<SysAuthDistributeSubDo>();
            for (AuthUserTagRelBo bo : reqBo.getAuthDistributeList()) {
                subDo = AuthRu.js(bo, SysAuthDistributeSubDo.class);
                ((SysAuthDistributeSubDo)subDo).setUpdateOperId(reqDo.getUpdateOperId());
                ((SysAuthDistributeSubDo)subDo).setUpdateOperName(reqDo.getUpdateOperName());
                ((SysAuthDistributeSubDo)subDo).setUpdateTime(reqDo.getUpdateTime());
                authDistributeList.add((SysAuthDistributeSubDo)subDo);
            }
            reqDo.setAuthDistributeList(authDistributeList);
        }
        return reqDo;
    }

    private void validateArg(AuthModifyUserInfoReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthCreateRoleInfoReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getCustInfoBo() == null && reqBo.getCustId() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[CustInfoBo\u548cCustId ]\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getAuthDistributeList())) {
            for (AuthDistributeBo bo : reqBo.getAuthDistributeList()) {
                if (bo.getRoleId() != null) continue;
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[RoleId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getUserTagRelList())) {
            for (AuthDistributeBo bo : reqBo.getUserTagRelList()) {
                if (bo.getTagId() != null) continue;
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[TagId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }

    private void addUserTag(SysUserInfoDo reqDo, List<SysUserTagRelSubDo> addTagList) {
        SysUserInfoDo addReqBo = new SysUserInfoDo();
        for (SysUserTagRelSubDo subDo : addTagList) {
            subDo.setRelId(IdUtil.nextId());
            subDo.setCreateOperId(reqDo.getUpdateOperId());
            subDo.setCreateOperName(reqDo.getCreateOperName());
            subDo.setCreateTime(reqDo.getUpdateTime());
            subDo.setUpdateOperId(reqDo.getUpdateOperId());
            subDo.setUpdateOperName(reqDo.getCreateOperName());
            subDo.setUpdateTime(reqDo.getUpdateTime());
        }
        addReqBo.setUserTagRelList(addTagList);
        this.iSysUserInfoModel.addUserTagList(addReqBo);
    }

    private void deleteUserTag(SysUserInfoDo reqDo, List<SysUserTagRelSubDo> deleteTagList) {
        SysUserInfoDo addReqBo = new SysUserInfoDo();
        for (SysUserTagRelSubDo subDo : deleteTagList) {
            subDo.setUpdateOperId(reqDo.getUpdateOperId());
            subDo.setUpdateOperName(reqDo.getCreateOperName());
            subDo.setUpdateTime(reqDo.getCreateTime());
            subDo.setDelFlag("1");
        }
        addReqBo.setUserTagRelList(deleteTagList);
        this.iSysUserInfoModel.updateUserTagList(addReqBo);
    }

    private void addUserRole(SysUserInfoDo reqDo, List<SysAuthDistributeSubDo> addRoleList) {
        SysUserInfoDo addReqBo = new SysUserInfoDo();
        for (SysAuthDistributeSubDo subDo : addRoleList) {
            subDo.setAuthId(IdUtil.nextId());
            subDo.setTenantId(reqDo.getTenantId());
            subDo.setUserId(reqDo.getUserId());
            subDo.setDisFlag(AuthDicConstant.ROLE_DIS_FLAG.USER);
            subDo.setCreateOperId(reqDo.getUpdateOperId());
            subDo.setCreateOperName(reqDo.getUpdateOperName());
            subDo.setCreateTime(reqDo.getUpdateTime());
            subDo.setUpdateOperId(reqDo.getUpdateOperId());
            subDo.setUpdateOperName(reqDo.getUpdateOperName());
            subDo.setUpdateTime(reqDo.getUpdateTime());
        }
        addReqBo.setAuthDistributeList(addRoleList);
        this.iSysUserInfoModel.addUserRoleList(addReqBo);
    }

    private void deleteUserRole(SysUserInfoDo reqDo, List<SysRoleInfoSubDo> deleteRoleList) {
        SysUserInfoDo addReqBo = new SysUserInfoDo();
        ArrayList<SysAuthDistributeSubDo> delRoleList = new ArrayList<SysAuthDistributeSubDo>();
        for (SysRoleInfoSubDo roleSubDo : deleteRoleList) {
            SysAuthDistributeSubDo subDo = new SysAuthDistributeSubDo();
            subDo.setRoleId(roleSubDo.getRoleId());
            subDo.setUserId(reqDo.getUserId());
            subDo.setUpdateOperId(reqDo.getUpdateOperId());
            subDo.setUpdateOperName(reqDo.getCreateOperName());
            subDo.setUpdateTime(reqDo.getCreateTime());
            subDo.setDelFlag("1");
            delRoleList.add(subDo);
        }
        addReqBo.setAuthDistributeList(delRoleList);
        this.iSysUserInfoModel.updateUserTagList(addReqBo);
    }
}

