/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.menu;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.dyc.authority.model.menu.ISysMenuModel;
import com.tydic.dyc.authority.model.menu.SysMenuDo;
import com.tydic.dyc.authority.service.menu.AuthCreateMenuService;
import com.tydic.dyc.authority.service.menu.bo.AuthCreateMenuReqBo;
import com.tydic.dyc.authority.service.menu.bo.AuthCreateMenuRspBo;
import com.tydic.dyc.authority.service.menu.bo.AuthMenuInfoBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.authority.utils.IdUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="authority_CENTER_DEV", serviceInterface=AuthCreateMenuService.class)
public class AuthCreateMenuServiceImpl
implements AuthCreateMenuService {
    @Autowired
    private ISysMenuModel iSysMenuModel;

    public AuthCreateMenuRspBo createMenu(AuthCreateMenuReqBo reqBo) {
        AuthCreateMenuRspBo rspBo = AuthRu.success(AuthCreateMenuRspBo.class);
        this.validateArg(reqBo);
        SysMenuDo reqDo = this.buildDoByBO(reqBo);
        reqDo.setMenuId(IdUtil.nextId());
        SysMenuDo rspDo = this.iSysMenuModel.createMenuInfo(reqDo);
        AuthMenuInfoBo menuInfoBo = AuthRu.js(rspDo, AuthMenuInfoBo.class);
        rspBo.setMenuInfoBo(menuInfoBo);
        return rspBo;
    }

    private SysMenuDo buildDoByBO(AuthCreateMenuReqBo reqBo) {
        reqBo.setCreateTime(new Date());
        SysMenuDo reqDo = AuthRu.js(reqBo, SysMenuDo.class);
        return reqDo;
    }

    private void validateArg(AuthCreateMenuReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthCreateMenuReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

