/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.menu;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.dyc.authority.model.menu.ISysMenuModel;
import com.tydic.dyc.authority.model.menu.SysMenuDo;
import com.tydic.dyc.authority.model.menu.qrybo.SysMenuQryBo;
import com.tydic.dyc.authority.service.menu.AuthGetMenuListService;
import com.tydic.dyc.authority.service.menu.bo.AuthGetMenuListReqBo;
import com.tydic.dyc.authority.service.menu.bo.AuthGetMenuListRspBo;
import com.tydic.dyc.authority.service.menu.bo.AuthMenuInfoBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="authority_CENTER_DEV", serviceInterface=AuthGetMenuListService.class)
public class AuthGetMenuListServiceImpl
implements AuthGetMenuListService {
    @Autowired
    private ISysMenuModel iSysMenuModel;

    public AuthGetMenuListRspBo getMenuList(AuthGetMenuListReqBo reqBo) {
        AuthGetMenuListRspBo rspBo = AuthRu.success(AuthGetMenuListRspBo.class);
        this.validateArg(reqBo);
        SysMenuQryBo qryBo = AuthRu.js(reqBo, SysMenuQryBo.class);
        List<SysMenuDo> rspDo = this.iSysMenuModel.getMenuList(qryBo);
        List<AuthMenuInfoBo> rows = AuthRu.jsl(rspDo, AuthMenuInfoBo.class);
        rspBo.setMenuInfoBoList(rows);
        return rspBo;
    }

    private void validateArg(AuthGetMenuListReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthCreateMenuReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getMenuId() != null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[MenuId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

