/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.menu;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.dyc.authority.model.menu.ISysMenuModel;
import com.tydic.dyc.authority.model.menu.SysMenuDo;
import com.tydic.dyc.authority.model.menu.qrybo.SysMenuQryBo;
import com.tydic.dyc.authority.service.menu.AuthShiftUpMenuService;
import com.tydic.dyc.authority.service.menu.bo.AuthMenuInfoBo;
import com.tydic.dyc.authority.service.menu.bo.AuthShiftUpMenuReqBo;
import com.tydic.dyc.authority.service.menu.bo.AuthShiftUpMenuRspBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="authority_CENTER_DEV", serviceInterface=AuthShiftUpMenuService.class)
public class AuthShiftUpMenuServiceImpl
implements AuthShiftUpMenuService {
    @Autowired
    private ISysMenuModel iSysMenuModel;

    public AuthShiftUpMenuRspBo dealShiftUpMenu(AuthShiftUpMenuReqBo reqBo) {
        AuthShiftUpMenuRspBo rspBo = AuthRu.success(AuthShiftUpMenuRspBo.class);
        this.validateArg(reqBo);
        SysMenuDo reqDo = this.buildDoByBO(reqBo);
        SysMenuQryBo downQryBo = new SysMenuQryBo();
        downQryBo.setMenuId(reqBo.getMenuId());
        SysMenuDo upDo = this.iSysMenuModel.getMenuInfoDetails(downQryBo);
        if (upDo == null || upDo.getMenuId() == null) {
            throw new BaseBusinessException("100001", "\u672a\u67e5\u8be2\u5230\u83dc\u5355\u4fe1\u606f");
        }
        downQryBo.setMenuId(reqBo.getMenuId());
        reqDo.setSort(upDo.getSort() + 1);
        SysMenuDo rspDo = this.iSysMenuModel.modifyMenuInfo(reqDo, downQryBo);
        AuthMenuInfoBo menuInfoBo = AuthRu.js(rspDo, AuthMenuInfoBo.class);
        SysMenuQryBo upQryBo = new SysMenuQryBo();
        if (upDo != null && upDo.getMenuId() != null) {
            if (upDo.getParentId() != null) {
                downQryBo.setParentId(downQryBo.getParentId());
            } else {
                downQryBo.setParentIdNull(0L);
            }
            upQryBo.setSort(upDo.getSort() + 1);
            SysMenuDo downDo = this.iSysMenuModel.getMenuInfoDetails(upQryBo);
            SysMenuQryBo qryBo = new SysMenuQryBo();
            qryBo.setMenuId(upDo.getMenuId());
            reqDo.setSort(downDo.getSort());
            SysMenuDo sysMenuDo = this.iSysMenuModel.modifyMenuInfo(reqDo, qryBo);
        }
        rspBo.setMenuInfoBo(menuInfoBo);
        return rspBo;
    }

    private SysMenuDo buildDoByBO(AuthShiftUpMenuReqBo reqBo) {
        reqBo.setUpdateTime(new Date());
        SysMenuDo reqDo = AuthRu.js(reqBo, SysMenuDo.class);
        return reqDo;
    }

    private void validateArg(AuthShiftUpMenuReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthCreateMenuReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getMenuId() != null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[MenuId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

