/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.organization;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.dyc.authority.model.organization.ISysOrgInfoModel;
import com.tydic.dyc.authority.model.organization.SysOrgInfoDo;
import com.tydic.dyc.authority.model.organization.qrybo.SysOrgInfoQryBo;
import com.tydic.dyc.authority.service.organization.AuthCreateOrgInfoService;
import com.tydic.dyc.authority.service.organization.bo.AuthCreateOrgInfoReqBo;
import com.tydic.dyc.authority.service.organization.bo.AuthCreateOrgInfoRspBo;
import com.tydic.dyc.authority.service.organization.bo.AuthOrgInfoBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.authority.utils.IdUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="authority_CENTER_DEV", serviceInterface=AuthCreateOrgInfoService.class)
public class AuthCreateOrgInfoServiceImpl
implements AuthCreateOrgInfoService {
    @Autowired
    private ISysOrgInfoModel iSysOrgInfoModel;

    public AuthCreateOrgInfoRspBo createOrgInfo(AuthCreateOrgInfoReqBo reqBo) {
        AuthCreateOrgInfoRspBo rspBo = AuthRu.success(AuthCreateOrgInfoRspBo.class);
        this.validateArg(reqBo);
        SysOrgInfoDo reqDo = this.buildDoByBO(reqBo);
        SysOrgInfoQryBo parentQryBo = new SysOrgInfoQryBo();
        parentQryBo.setParentId(reqBo.getParentId());
        SysOrgInfoDo parentOrgDo = this.iSysOrgInfoModel.getOrgInfoDetails(parentQryBo);
        if (parentOrgDo == null || parentOrgDo.getTenantId() == null) {
            throw new BaseBusinessException("100001", "\u672a\u67e5\u8be2\u5230\u673a\u6784\u4fe1\u606f");
        }
        reqDo.setOrgId(IdUtil.nextId());
        String treePath = parentOrgDo.getOrgTreePath() + reqBo.getOrgId() + "-";
        reqDo.setOrgTreePath(treePath);
        reqDo.setDeep(parentOrgDo.getDeep() + 1);
        reqDo.setTenantId(parentOrgDo.getTenantId());
        SysOrgInfoDo rspDo = this.iSysOrgInfoModel.createOrgInfo(reqDo);
        AuthOrgInfoBo DoToBo = AuthRu.js(rspDo, AuthOrgInfoBo.class);
        rspBo.setOrgInfoBo(DoToBo);
        return rspBo;
    }

    private SysOrgInfoDo buildDoByBO(AuthCreateOrgInfoReqBo reqBo) {
        reqBo.setCreateTime(new Date());
        reqBo.setUpdateTime(reqBo.getCreateTime());
        SysOrgInfoDo reqDo = AuthRu.js(reqBo, SysOrgInfoDo.class);
        return reqDo;
    }

    private void validateArg(AuthCreateOrgInfoReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthCreateOrgInfoReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getParentId() != null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[\u7236\u673a\u6784Id parentId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

