/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.organization;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.dyc.authority.model.organization.ISysOrgInfoModel;
import com.tydic.dyc.authority.model.organization.SysOrgInfoDo;
import com.tydic.dyc.authority.model.organization.qrybo.SysOrgInfoQryBo;
import com.tydic.dyc.authority.model.organization.qrybo.SysOrgTagRelQryBo;
import com.tydic.dyc.authority.model.organization.sub.SysOrgTagRelSubDo;
import com.tydic.dyc.authority.service.organization.AuthGetOrgInfoDetailService;
import com.tydic.dyc.authority.service.organization.bo.AuthGetOrgInfoDetailReqBo;
import com.tydic.dyc.authority.service.organization.bo.AuthGetOrgInfoDetailRspBo;
import com.tydic.dyc.authority.service.organization.bo.AuthOrgInfoBo;
import com.tydic.dyc.authority.service.organization.bo.AuthOrgTagRelBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="authority_CENTER_DEV", serviceInterface=AuthGetOrgInfoDetailService.class)
public class AuthGetOrgInfoDetailServiceImpl
implements AuthGetOrgInfoDetailService {
    @Autowired
    private ISysOrgInfoModel iSysOrgInfoModel;

    public AuthGetOrgInfoDetailRspBo getOrgInfoDetail(AuthGetOrgInfoDetailReqBo reqBo) {
        AuthGetOrgInfoDetailRspBo rspBo = AuthRu.success(AuthGetOrgInfoDetailRspBo.class);
        this.validateArg(reqBo);
        SysOrgInfoQryBo qryBo = new SysOrgInfoQryBo();
        qryBo.setOrgId(reqBo.getOrgId());
        SysOrgInfoDo rspDo = this.iSysOrgInfoModel.getOrgInfoDetails(qryBo);
        if (rspDo == null || rspDo.getOrgId() == null) {
            throw new BaseBusinessException("100001", "\u672a\u67e5\u8be2\u5230\u673a\u6784\u4fe1\u606f");
        }
        AuthOrgInfoBo DoToBo = AuthRu.js(rspDo, AuthOrgInfoBo.class);
        SysOrgTagRelQryBo tagQryBo = new SysOrgTagRelQryBo();
        tagQryBo.setOrgId(rspDo.getOrgId());
        List<SysOrgTagRelSubDo> orgTagDoList = this.iSysOrgInfoModel.getOrgTagList(tagQryBo);
        List<AuthOrgTagRelBo> orgTagBoList = AuthRu.jsl(orgTagDoList, AuthOrgTagRelBo.class);
        DoToBo.setOrgTagList(orgTagBoList);
        rspBo.setOrgInfoBo(DoToBo);
        return rspBo;
    }

    private void validateArg(AuthGetOrgInfoDetailReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthGetOrgInfoDetailReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getOrgId() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[orgId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

