/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.organization;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.dyc.authority.model.organization.ISysOrgInfoModel;
import com.tydic.dyc.authority.model.organization.SysOrgInfoDo;
import com.tydic.dyc.authority.model.organization.qrybo.SysOrgInfoQryBo;
import com.tydic.dyc.authority.service.organization.AuthModifyOrgInfoService;
import com.tydic.dyc.authority.service.organization.bo.AuthModifyOrgInfoReqBo;
import com.tydic.dyc.authority.service.organization.bo.AuthModifyOrgInfoRspBo;
import com.tydic.dyc.authority.service.organization.bo.AuthOrgInfoBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="authority_CENTER_DEV", serviceInterface=AuthModifyOrgInfoService.class)
public class AuthModifyOrgInfoServiceImpl
implements AuthModifyOrgInfoService {
    @Autowired
    private ISysOrgInfoModel iSysOrgInfoModel;

    public AuthModifyOrgInfoRspBo modifyOrgInfo(AuthModifyOrgInfoReqBo reqBo) {
        AuthModifyOrgInfoRspBo rspBo = AuthRu.success(AuthModifyOrgInfoRspBo.class);
        this.validateArg(reqBo);
        SysOrgInfoQryBo qryBo = new SysOrgInfoQryBo();
        qryBo.setOrgId(reqBo.getOrgId());
        SysOrgInfoDo rspDoDetail = this.iSysOrgInfoModel.getOrgInfoDetails(qryBo);
        if (rspDoDetail == null || rspDoDetail.getOrgId() == null) {
            throw new BaseBusinessException("100001", "\u672a\u67e5\u8be2\u5230\u673a\u6784\u4fe1\u606f");
        }
        SysOrgInfoDo reqDo = this.buildDoByBO(reqBo);
        SysOrgInfoDo rspDo = this.iSysOrgInfoModel.modifyOrgInfo(reqDo, qryBo);
        AuthOrgInfoBo DoToBo = AuthRu.js(rspDo, AuthOrgInfoBo.class);
        rspBo.setOrgInfoBo(DoToBo);
        return rspBo;
    }

    private SysOrgInfoDo buildDoByBO(AuthModifyOrgInfoReqBo reqBo) {
        reqBo.setUpdateTime(new Date());
        SysOrgInfoDo reqDo = AuthRu.js(reqBo, SysOrgInfoDo.class);
        return reqDo;
    }

    private void validateArg(AuthModifyOrgInfoReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthModifyOrgInfoReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getOrgId() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[orgId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

