/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.tenant;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.dyc.authority.model.organization.ISysOrgInfoModel;
import com.tydic.dyc.authority.model.tenant.ISysTenantModel;
import com.tydic.dyc.authority.model.tenant.SysTenantInfoDo;
import com.tydic.dyc.authority.service.tenant.AuthCreateTenantInfoService;
import com.tydic.dyc.authority.service.tenant.bo.AuthCreateTenantInfoReqBo;
import com.tydic.dyc.authority.service.tenant.bo.AuthCreateTenantInfoRspBo;
import com.tydic.dyc.authority.service.tenant.bo.AuthTenantInfoBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.authority.utils.IdUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="authority_CENTER_DEV", serviceInterface=AuthCreateTenantInfoService.class)
public class AuthCreateTenantInfoServiceImpl
implements AuthCreateTenantInfoService {
    @Autowired
    private ISysTenantModel iSysTenantModel;
    @Autowired
    private ISysOrgInfoModel iSysOrgInfoModel;

    public AuthCreateTenantInfoRspBo createTenantInfo(AuthCreateTenantInfoReqBo reqBo) {
        AuthCreateTenantInfoRspBo rspBo = AuthRu.success(AuthCreateTenantInfoRspBo.class);
        this.validateArg(reqBo);
        SysTenantInfoDo reqDo = this.buildDoByBO(reqBo);
        reqDo.setTenantId(IdUtil.nextId());
        reqDo.setOrgRootId(IdUtil.nextId());
        SysTenantInfoDo rspDo = this.iSysTenantModel.createTenantInfo(reqDo);
        AuthTenantInfoBo DoToBo = AuthRu.js(rspDo, AuthTenantInfoBo.class);
        rspBo.setTenantInfoBo(DoToBo);
        return rspBo;
    }

    private SysTenantInfoDo buildDoByBO(AuthCreateTenantInfoReqBo reqBo) {
        reqBo.setCreateTime(new Date());
        SysTenantInfoDo reqDo = AuthRu.js(reqBo, SysTenantInfoDo.class);
        return reqDo;
    }

    private void validateArg(AuthCreateTenantInfoReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthCreateTenantInfoReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

