/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.domainservice;

import com.tydic.dyc.authority.model.common.sub.SysRoleInfoSubDo;
import com.tydic.dyc.authority.model.menu.ISysMenuModel;
import com.tydic.dyc.authority.model.menu.SysMenuDo;
import com.tydic.dyc.authority.model.menu.qrybo.SysMenuQryBo;
import com.tydic.dyc.authority.model.organization.ISysOrgInfoModel;
import com.tydic.dyc.authority.model.organization.SysOrgInfoDo;
import com.tydic.dyc.authority.model.organization.qrybo.SysOrgInfoQryBo;
import com.tydic.dyc.authority.model.user.ISysUserInfoModel;
import com.tydic.dyc.authority.model.user.SysUserInfoDo;
import com.tydic.dyc.authority.model.user.qrybo.SysUserInfoQryBo;
import com.tydic.dyc.authority.service.domainservice.AuthGetPowerMenuListByUserService;
import com.tydic.dyc.authority.service.domainservice.bo.AuthGetPowerMenuListByUserReqBo;
import com.tydic.dyc.authority.service.domainservice.bo.AuthGetPowerMenuListByUserRspBo;
import com.tydic.dyc.authority.service.menu.bo.AuthButtonInfoBo;
import com.tydic.dyc.authority.service.menu.bo.AuthMenuInfoBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AUTHORITY_CENTER_DEV/2.0.0/com.tydic.dyc.authority.service.domainservice.AuthGetPowerMenuListByUserService"})
public class AuthGetPowerMenuListByUserServiceImpl
implements AuthGetPowerMenuListByUserService {
    @Autowired
    private ISysUserInfoModel iSysUserInfoModel;
    @Autowired
    private ISysMenuModel iSysMenuModel;
    @Autowired
    private ISysOrgInfoModel iSysOrgInfoModel;

    @PostMapping(value={"getPowerMenuListByUser"})
    public AuthGetPowerMenuListByUserRspBo getPowerMenuListByUser(@RequestBody AuthGetPowerMenuListByUserReqBo reqBo) {
        this.validateArg(reqBo);
        AuthGetPowerMenuListByUserRspBo rspBo = new AuthGetPowerMenuListByUserRspBo();
        SysUserInfoQryBo operUserReqBo = new SysUserInfoQryBo();
        operUserReqBo.setUserId(reqBo.getUserId());
        SysUserInfoDo operInfoDo = this.iSysUserInfoModel.getUserInfoDetails(operUserReqBo);
        if (operInfoDo == null || operInfoDo.getUserId() == null) {
            throw new BaseBusinessException("100001", "\u672a\u67e5\u8be2\u5230\u64cd\u4f5c\u7528\u6237\u4fe1\u606f");
        }
        List<Long> roleIdList = new ArrayList<Long>();
        if (!"auth:system:manage".equals(operInfoDo.getAuthorityType())) {
            SysOrgInfoQryBo orgQryBo = new SysOrgInfoQryBo();
            orgQryBo.setOrgId(operInfoDo.getOrgId());
            SysOrgInfoDo orgInfoDo = this.iSysOrgInfoModel.getRoleInfoListByOrg(orgQryBo);
            Map orgRoleMaps = orgInfoDo.getOrgRoleList().stream().collect(Collectors.toMap(SysRoleInfoSubDo::getRoleId, Function.identity()));
            SysUserInfoQryBo userInfoQryBo = new SysUserInfoQryBo();
            userInfoQryBo.setUserId(reqBo.getUserId());
            SysUserInfoDo userInfoDo = this.iSysUserInfoModel.getRoleInfoListByUser(userInfoQryBo);
            Map userRolemaps = userInfoDo.getUserRoleList().stream().collect(Collectors.toMap(SysRoleInfoSubDo::getRoleId, Function.identity()));
            orgRoleMaps.putAll(userRolemaps);
            ArrayList roleInfoSubDoList = new ArrayList(orgRoleMaps.values());
            if (CollectionUtils.isEmpty(roleInfoSubDoList)) {
                throw new BaseBusinessException("100001", "\u672a\u67e5\u8be2\u5230\u64cd\u4f5c\u7528\u6237\u89d2\u8272\u4fe1\u606f");
            }
            roleIdList = roleInfoSubDoList.stream().map(SysRoleInfoSubDo::getRoleId).collect(Collectors.toList());
        }
        SysMenuQryBo menuQryBo = new SysMenuQryBo();
        menuQryBo.setPowerRoleIdList(roleIdList);
        menuQryBo.setApplicationCode(reqBo.getApplicationCode());
        List<SysMenuDo> allMenuDoList = this.iSysMenuModel.getMenuList(menuQryBo);
        ArrayList<String> powerOrgThreePathList = new ArrayList<String>();
        powerOrgThreePathList.add(reqBo.getOrgThreePath());
        if (!"1".equals(reqBo.getMenuQryType()) && "2".equals(reqBo.getMenuQryType())) {
            menuQryBo.setPowerOrgThreePathList(powerOrgThreePathList);
        }
        List<SysMenuDo> hasMenuDoList = this.iSysMenuModel.getMenuList(menuQryBo);
        Map hasMenuMap = hasMenuDoList.stream().collect(Collectors.toMap(SysMenuDo::getMenuId, Function.identity()));
        for (SysMenuDo menuDo : allMenuDoList) {
            if (hasMenuMap.get(menuDo.getMenuId()) != null) {
                menuDo.setHasSel(true);
                continue;
            }
            menuDo.setHasSel(false);
        }
        List<AuthMenuInfoBo> menuInfos = AuthRu.jsl(allMenuDoList, AuthMenuInfoBo.class);
        if (menuInfos.size() > 0) {
            List<AuthMenuInfoBo> buildByRecursive = this.buildByRecursive(menuInfos);
            rspBo.setMenuInfoList(buildByRecursive);
        }
        return rspBo;
    }

    private void validateArg(AuthGetPowerMenuListByUserReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthGetPowerMenuListByUserReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getUserId() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[UserId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getMenuQryType() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[operType]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getOrgThreePath() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[OrgThreePath]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getApplicationCode() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[applicationCode]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private List<AuthMenuInfoBo> buildByRecursive(List<AuthMenuInfoBo> treeNodes) {
        Collections.sort(treeNodes);
        ArrayList<AuthMenuInfoBo> trees = new ArrayList<AuthMenuInfoBo>();
        for (AuthMenuInfoBo treeNode : treeNodes) {
            if (treeNode.getParentId() != null) continue;
            trees.add(this.findChildren(treeNode, treeNodes));
        }
        Collections.sort(trees);
        return trees;
    }

    private AuthMenuInfoBo findChildren(AuthMenuInfoBo root, List<AuthMenuInfoBo> allMenus) {
        for (AuthMenuInfoBo it : allMenus) {
            if (!root.getMenuId().equals(it.getParentId())) continue;
            if (root.getChildren() == null) {
                root.setChildren(new ArrayList());
            }
            if (root.getAuthButtons() == null) {
                root.setAuthButtons(new ArrayList());
            }
            if ("F".equals(it.getMenuType())) {
                root.getAuthButtons().add(AuthRu.js(it, AuthButtonInfoBo.class));
                continue;
            }
            root.getChildren().add(this.findChildren(it, allMenus));
        }
        return root;
    }
}

