/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.subpage;

import com.tydic.dyc.authority.model.menu.ISysMenuModel;
import com.tydic.dyc.authority.model.menu.SysMenuDo;
import com.tydic.dyc.authority.model.menu.qrybo.SysMenuQryBo;
import com.tydic.dyc.authority.model.subpage.ISysSubpageModel;
import com.tydic.dyc.authority.model.subpage.SysSubpageDo;
import com.tydic.dyc.authority.model.subpage.qrybo.SysSubpageQryBo;
import com.tydic.dyc.authority.service.subpage.AuthCreateSubpageService;
import com.tydic.dyc.authority.service.subpage.bo.AuthCreateSubpageReqBo;
import com.tydic.dyc.authority.service.subpage.bo.AuthCreateSubpageRspBo;
import com.tydic.dyc.authority.service.subpage.bo.AuthSubpageInfoBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.authority.utils.IdUtil;
import com.tydic.dyc.authority.utils.StrUtil;
import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AUTHORITY_CENTER_DEV/2.0.0/com.tydic.dyc.authority.service.subpage.AuthCreateSubpageService"})
public class AuthCreateSubpageServiceImpl
implements AuthCreateSubpageService {
    @Autowired
    private ISysSubpageModel iSysSubpageModel;
    @Autowired
    private ISysMenuModel iSysMenuModel;

    @PostMapping(value={"createSubpage"})
    public AuthCreateSubpageRspBo createSubpage(@RequestBody AuthCreateSubpageReqBo reqBo) {
        AuthCreateSubpageRspBo rspBo = AuthRu.success(AuthCreateSubpageRspBo.class);
        this.validateArg(reqBo);
        SysMenuQryBo menuQryBo = new SysMenuQryBo();
        menuQryBo.setMenuCode(reqBo.getPageCode());
        List<SysMenuDo> menuList = this.iSysMenuModel.getMenuList(menuQryBo);
        if (!CollectionUtils.isEmpty(menuList)) {
            throw new BaseBusinessException("100001", "\u83dc\u5355\u7f16\u7801\u4e0d\u80fd\u91cd\u590d");
        }
        SysSubpageQryBo subpageQryBo = new SysSubpageQryBo();
        subpageQryBo.setPageCode(reqBo.getPageCode());
        BasePageRspBo<SysSubpageDo> subpageList = this.iSysSubpageModel.getSubpageList(subpageQryBo);
        if (!CollectionUtils.isEmpty((Collection)subpageList.getRows())) {
            throw new BaseBusinessException("100001", "\u5b50\u9875\u9762\u7f16\u7801\u4e0d\u80fd\u91cd\u590d");
        }
        SysSubpageDo reqDo = this.buildDoByBO(reqBo);
        reqDo.setPageId(IdUtil.nextId());
        SysSubpageDo rspDo = this.iSysSubpageModel.createSubpageInfo(reqDo);
        AuthSubpageInfoBo menuInfoBo = AuthRu.js(rspDo, AuthSubpageInfoBo.class);
        rspBo.setSubpageInfoBo(menuInfoBo);
        return rspBo;
    }

    private SysSubpageDo buildDoByBO(AuthCreateSubpageReqBo reqBo) {
        reqBo.setCreateTime(new Date());
        reqBo.setPageStatus("1");
        SysSubpageDo reqDo = StrUtil.noNullStringAttr(AuthRu.js(reqBo, SysSubpageDo.class));
        return reqDo;
    }

    private void validateArg(AuthCreateSubpageReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthCreateSubpageReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

