/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.subpage;

import com.tydic.dyc.authority.model.subpage.ISysSubpageModel;
import com.tydic.dyc.authority.model.subpage.SysSubpageDo;
import com.tydic.dyc.authority.model.subpage.qrybo.SysSubpageQryBo;
import com.tydic.dyc.authority.model.subpageRel.ISysSubPageRelModel;
import com.tydic.dyc.authority.service.subpage.AuthGetSubpageListService;
import com.tydic.dyc.authority.service.subpage.bo.AuthGetSubpageListReqBo;
import com.tydic.dyc.authority.service.subpage.bo.AuthGetSubpageListRspBo;
import com.tydic.dyc.authority.service.subpage.bo.AuthMenuBindPageBo;
import com.tydic.dyc.authority.service.subpage.bo.AuthSubpageInfoBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.authority.utils.StrUtil;
import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AUTHORITY_CENTER_DEV/2.0.0/com.tydic.dyc.authority.service.subpage.AuthGetSubpageListService"})
public class AuthGetSubpageListServiceImpl
implements AuthGetSubpageListService {
    @Autowired
    private ISysSubpageModel iSysSubpageModel;
    @Autowired
    private ISysSubPageRelModel iSysSubPageRelModel;

    @PostMapping(value={"getSubpageList"})
    public AuthGetSubpageListRspBo getSubpageList(@RequestBody AuthGetSubpageListReqBo reqBo) {
        AuthGetSubpageListRspBo rspBo = AuthRu.success(AuthGetSubpageListRspBo.class);
        this.validateArg(reqBo);
        SysSubpageQryBo qryBo = StrUtil.noNullStringAttr(AuthRu.js(reqBo, SysSubpageQryBo.class));
        BasePageRspBo<SysSubpageDo> rspDo = this.iSysSubpageModel.getSubpageList(qryBo);
        rspBo = AuthRu.js(rspDo, AuthGetSubpageListRspBo.class);
        List<AuthSubpageInfoBo> rows = AuthRu.jsl(rspDo.getRows(), AuthSubpageInfoBo.class);
        rspBo.setRows(rows);
        if (!StringUtils.isBlank((CharSequence)reqBo.getOperType()) && "1".equals(reqBo.getOperType())) {
            AuthMenuBindPageBo authMenuBindPageBo = new AuthMenuBindPageBo();
            ArrayList<String> menuIds = new ArrayList<String>();
            menuIds.add(reqBo.getMenuId().toString());
            authMenuBindPageBo.setMenuIds(menuIds);
            List<AuthMenuBindPageBo> bindPageBos = this.iSysSubPageRelModel.queryMenuBoundPage(authMenuBindPageBo);
            Map map = bindPageBos.stream().collect(Collectors.toMap(AuthMenuBindPageBo::getPageId, Function.identity(), (key1, key2) -> key2));
            for (AuthSubpageInfoBo row : rspBo.getRows()) {
                AuthMenuBindPageBo pageBo = (AuthMenuBindPageBo)map.get(row.getPageId().toString());
                if (null != pageBo) {
                    row.setBindStatus("2");
                    row.setRelId(pageBo.getRelId());
                    continue;
                }
                row.setBindStatus("1");
            }
        }
        return rspBo;
    }

    private void validateArg(AuthGetSubpageListReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthGetSubpageListReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public static void main(String[] args) {
    }
}

