/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.user;

import com.tydic.dyc.authority.constants.AuthDicConstant;
import com.tydic.dyc.authority.model.common.sub.SysAuthDistributeSubDo;
import com.tydic.dyc.authority.model.common.sub.SysRoleInfoSubDo;
import com.tydic.dyc.authority.model.user.ISysUserInfoModel;
import com.tydic.dyc.authority.model.user.SysUserInfoDo;
import com.tydic.dyc.authority.model.user.qrybo.SysUserInfoQryBo;
import com.tydic.dyc.authority.service.domainservice.bo.AuthDistributeBo;
import com.tydic.dyc.authority.service.user.AuthDealUserRoleService;
import com.tydic.dyc.authority.service.user.bo.AuthDealUserRoleReqBo;
import com.tydic.dyc.authority.service.user.bo.AuthDealUserRoleRspBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.authority.utils.IdUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AUTHORITY_CENTER_DEV/2.0.0/com.tydic.dyc.authority.service.user.AuthDealUserRoleService"})
public class AuthDealUserRoleServiceImpl
implements AuthDealUserRoleService {
    @Autowired
    private ISysUserInfoModel iSysUserInfoModel;

    @PostMapping(value={"dealUserRole"})
    public AuthDealUserRoleRspBo dealUserRole(@RequestBody AuthDealUserRoleReqBo reqBo) {
        AuthDealUserRoleRspBo rspBo = AuthRu.success(AuthDealUserRoleRspBo.class);
        this.validateArg(reqBo);
        SysUserInfoDo reqDo = AuthRu.js(reqBo, SysUserInfoDo.class);
        SysUserInfoQryBo qryBo = new SysUserInfoQryBo();
        qryBo.setUserId(reqBo.getUserId());
        SysUserInfoDo userInfoDo = this.iSysUserInfoModel.getUserInfoDetails(qryBo);
        if (userInfoDo == null || userInfoDo.getUserId() == null) {
            throw new BaseBusinessException("100001", "\u672a\u67e5\u8be2\u5230\u7528\u6237\u4fe1\u606f");
        }
        SysUserInfoDo userRoleDo = this.iSysUserInfoModel.getRoleInfoListByUser(qryBo);
        List<SysRoleInfoSubDo> oldRoleList = userRoleDo.getUserRoleList();
        List<SysAuthDistributeSubDo> addSubDo = reqDo.getAuthDistributeList();
        ArrayList<SysAuthDistributeSubDo> eqaulsSubDo = new ArrayList<SysAuthDistributeSubDo>();
        ArrayList<SysRoleInfoSubDo> eqaulsRoleList = new ArrayList<SysRoleInfoSubDo>();
        block0: for (SysRoleInfoSubDo oldSubDo : oldRoleList) {
            for (SysAuthDistributeSubDo reqDistributeSubDo : addSubDo) {
                if (!oldSubDo.getRoleId().equals(reqDistributeSubDo.getRoleId())) continue;
                eqaulsSubDo.add(reqDistributeSubDo);
                eqaulsRoleList.add(oldSubDo);
                continue block0;
            }
        }
        oldRoleList.removeAll(eqaulsRoleList);
        addSubDo.removeAll(eqaulsSubDo);
        this.addUserRole(reqDo, addSubDo);
        this.deleteUserRole(reqDo, oldRoleList);
        return rspBo;
    }

    private void addUserRole(SysUserInfoDo reqDo, List<SysAuthDistributeSubDo> addRoleList) {
        SysUserInfoDo addReqBo = new SysUserInfoDo();
        for (SysAuthDistributeSubDo subDo : addRoleList) {
            subDo.setAuthId(IdUtil.nextId());
            subDo.setTenantId(reqDo.getTenantId());
            subDo.setUserId(reqDo.getUserId());
            subDo.setDisFlag(AuthDicConstant.ROLE_DIS_FLAG.USER);
            subDo.setCreateOperId(reqDo.getUpdateOperId());
            subDo.setCreateOperName(reqDo.getUpdateOperName());
            subDo.setCreateTime(reqDo.getUpdateTime());
            subDo.setUpdateOperId(reqDo.getUpdateOperId());
            subDo.setUpdateOperName(reqDo.getUpdateOperName());
            subDo.setUpdateTime(reqDo.getUpdateTime());
        }
        addReqBo.setAuthDistributeList(addRoleList);
        this.iSysUserInfoModel.addUserRoleList(addReqBo);
    }

    private void deleteUserRole(SysUserInfoDo reqDo, List<SysRoleInfoSubDo> deleteRoleList) {
        SysUserInfoDo addReqBo = new SysUserInfoDo();
        ArrayList<SysAuthDistributeSubDo> delRoleList = new ArrayList<SysAuthDistributeSubDo>();
        for (SysRoleInfoSubDo roleSubDo : deleteRoleList) {
            SysAuthDistributeSubDo subDo = new SysAuthDistributeSubDo();
            subDo.setRoleId(roleSubDo.getRoleId());
            subDo.setUserId(reqDo.getUserId());
            subDo.setUpdateOperId(reqDo.getUpdateOperId());
            subDo.setUpdateOperName(reqDo.getCreateOperName());
            subDo.setUpdateTime(reqDo.getCreateTime());
            subDo.setDelFlag("1");
            delRoleList.add(subDo);
        }
        addReqBo.setAuthDistributeList(delRoleList);
        this.iSysUserInfoModel.updateUserRoleList(addReqBo);
    }

    private void validateArg(AuthDealUserRoleReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthDealUserRoleReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getUserId() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[OrgId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getAuthDistributeList())) {
            for (AuthDistributeBo bo : reqBo.getAuthDistributeList()) {
                if (bo.getRoleId() != null) continue;
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[RoleId]\u4e0d\u80fd\u90fd\u4e3a\u7a7a");
            }
        }
    }
}

