/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.menu;

import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.authority.model.menu.ISysMenuModel;
import com.tydic.dyc.authority.model.menu.SysMenuDo;
import com.tydic.dyc.authority.model.menu.qrybo.SysMenuQryBo;
import com.tydic.dyc.authority.model.subpageRel.ISysSubPageRelModel;
import com.tydic.dyc.authority.service.menu.AuthGetMenuListService;
import com.tydic.dyc.authority.service.menu.bo.AuthGetMenuListReqBo;
import com.tydic.dyc.authority.service.menu.bo.AuthGetMenuListRspBo;
import com.tydic.dyc.authority.service.menu.bo.AuthMenuInfoBo;
import com.tydic.dyc.authority.service.subpage.bo.AuthMenuBindPageBo;
import com.tydic.dyc.authority.service.subpage.bo.AuthSubpageInfoBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.authority.utils.StrUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AUTHORITY_CENTER_DEV/2.0.0/com.tydic.dyc.authority.service.menu.AuthGetMenuListService"})
public class AuthGetMenuListServiceImpl
implements AuthGetMenuListService {
    @Autowired
    private ISysMenuModel iSysMenuModel;
    @Autowired
    private ISysSubPageRelModel iSysSubPageRelModel;

    @PostMapping(value={"getMenuList"})
    public AuthGetMenuListRspBo getMenuList(@RequestBody AuthGetMenuListReqBo reqBo) {
        AuthGetMenuListRspBo rspBo = AuthRu.success(AuthGetMenuListRspBo.class);
        this.validateArg(reqBo);
        SysMenuQryBo qryBo = StrUtil.noNullStringAttr(AuthRu.js(reqBo, SysMenuQryBo.class));
        List<SysMenuDo> rspDo = this.iSysMenuModel.getMenuList(qryBo);
        List menuIds = rspDo.stream().map(SysMenuDo::getMenuId).collect(Collectors.toList());
        Map<Object, Object> bindPageMap = new HashMap();
        if (!CollectionUtils.isEmpty(menuIds)) {
            AuthMenuBindPageBo authMenuBindPageBo = new AuthMenuBindPageBo();
            List strList1 = menuIds.stream().collect(Collectors.toList());
            authMenuBindPageBo.setMenuIds(strList1);
            List<AuthMenuBindPageBo> bindPageBos = this.iSysSubPageRelModel.queryMenuBoundPage(authMenuBindPageBo);
            bindPageMap = bindPageBos.stream().collect(Collectors.groupingBy(AuthMenuBindPageBo::getMenuId));
        }
        List<AuthMenuInfoBo> rows = AuthRu.jsl(rspDo, AuthMenuInfoBo.class);
        for (AuthMenuInfoBo authMenuInfoBo : rows) {
            authMenuInfoBo.setSubPages(JSONObject.parseArray((String)JSONObject.toJSONString(bindPageMap.get(authMenuInfoBo.getMenuId())), AuthSubpageInfoBo.class));
        }
        rspBo.setMenuInfoBoList(rows);
        return rspBo;
    }

    private void validateArg(AuthGetMenuListReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthCreateMenuReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

