/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.user;

import com.tydic.dyc.authority.model.user.ISysUserInfoModel;
import com.tydic.dyc.authority.model.user.SysUserInfoDo;
import com.tydic.dyc.authority.model.user.qrybo.SysCustInfoQryBo;
import com.tydic.dyc.authority.model.user.qrybo.SysUserInfoQryBo;
import com.tydic.dyc.authority.service.user.AuthDeleteUserInfoService;
import com.tydic.dyc.authority.service.user.bo.AuthDeleteUserInfoReqBo;
import com.tydic.dyc.authority.service.user.bo.AuthDeleteUserInfoRspBo;
import com.tydic.dyc.authority.service.user.bo.AuthUserInfoBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AUTHORITY_CENTER_DEV/2.0.0/com.tydic.dyc.authority.service.user.AuthDeleteUserInfoService"})
public class AuthDeleteUserInfoServiceImpl
implements AuthDeleteUserInfoService {
    @Autowired
    private ISysUserInfoModel iSysUserInfoModel;

    @PostMapping(value={"deleteUserInfo"})
    public AuthDeleteUserInfoRspBo deleteUserInfo(@RequestBody AuthDeleteUserInfoReqBo reqBo) {
        AuthDeleteUserInfoRspBo rspBo = AuthRu.success(AuthDeleteUserInfoRspBo.class);
        this.validateArg(reqBo);
        SysUserInfoDo reqDo = this.buildDoByBO(reqBo);
        SysUserInfoQryBo qryBo = new SysUserInfoQryBo();
        qryBo.setUserId(reqBo.getUserId());
        SysUserInfoDo userInfoDo = this.iSysUserInfoModel.getUserInfoDetails(qryBo);
        if (userInfoDo == null || userInfoDo.getUserId() == null) {
            throw new BaseBusinessException("100001", "\u672a\u67e5\u8be2\u5230\u7528\u6237\u4fe1\u606f");
        }
        SysUserInfoDo rspDo = this.iSysUserInfoModel.modifyUserInfo(reqDo, qryBo);
        SysUserInfoQryBo listQryBo = new SysUserInfoQryBo();
        if (userInfoDo.getCustId() != null) {
            listQryBo.setCustId(userInfoDo.getCustId());
            List<SysUserInfoDo> userList = this.iSysUserInfoModel.getUserList(listQryBo);
            if (CollectionUtils.isEmpty(userList)) {
                SysCustInfoQryBo set = new SysCustInfoQryBo();
                SysCustInfoQryBo where = new SysCustInfoQryBo();
                set.setDelFlag("1");
                where.setCustId(userInfoDo.getCustId());
                this.iSysUserInfoModel.updateCustInfo(set, where);
            }
        }
        AuthUserInfoBo DoToBo = AuthRu.js(rspDo, AuthUserInfoBo.class);
        rspBo.setUserInfoBo(DoToBo);
        return rspBo;
    }

    private SysUserInfoDo buildDoByBO(AuthDeleteUserInfoReqBo reqBo) {
        reqBo.setUpdateTime(reqBo.getUpdateTime());
        SysUserInfoDo reqDo = AuthRu.js(reqBo, SysUserInfoDo.class);
        reqDo.setDelFlag("1");
        return reqDo;
    }

    private void validateArg(AuthDeleteUserInfoReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthDeleteUserInfoReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getUserId() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[UserId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

