/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.role;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.authority.model.organization.ISysOrgInfoModel;
import com.tydic.dyc.authority.model.organization.SysOrgInfoDo;
import com.tydic.dyc.authority.model.organization.qrybo.SysOrgInfoQryBo;
import com.tydic.dyc.authority.service.role.AuthDataPowerOrgTreeEchoService;
import com.tydic.dyc.authority.service.role.bo.AuthDataPowerOrgTreeEchoReqBo;
import com.tydic.dyc.authority.service.role.bo.AuthDataPowerOrgTreeEchoRspBo;
import com.tydic.dyc.authority.service.role.bo.AuthOtherOrgBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AUTHORITY_CENTER_DEV/2.0.0/com.tydic.dyc.authority.service.role.AuthDataPowerOrgTreeEchoService"})
public class AuthDataPowerOrgTreeEchoServiceImpl
implements AuthDataPowerOrgTreeEchoService {
    @Autowired
    private ISysOrgInfoModel iSysOrgInfoModel;
    private List<AuthOtherOrgBo> tree = new ArrayList<AuthOtherOrgBo>();

    @PostMapping(value={"getDataPowerOrgTreeEcho"})
    public AuthDataPowerOrgTreeEchoRspBo getDataPowerOrgTreeEcho(@RequestBody AuthDataPowerOrgTreeEchoReqBo reqBo) {
        AuthDataPowerOrgTreeEchoRspBo rspBo = AuthRu.success(AuthDataPowerOrgTreeEchoRspBo.class);
        this.validateArg(reqBo);
        this.tree = new ArrayList<AuthOtherOrgBo>();
        ArrayList<AuthOtherOrgBo> list = new ArrayList<AuthOtherOrgBo>();
        for (Long orgId : reqBo.getOrgIdList()) {
            List<AuthOtherOrgBo> orgBoList = this.createTree(orgId);
            list.addAll(orgBoList);
        }
        List collect = list.stream().distinct().collect(Collectors.toList());
        rspBo.setRows(collect);
        return rspBo;
    }

    private void validateArg(AuthDataPowerOrgTreeEchoReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthDataPowerOrgTreeEchoReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getOrgIdList() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[orgIdList]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private List<AuthOtherOrgBo> createTree(Long orgId) {
        SysOrgInfoQryBo orgQryBo = new SysOrgInfoQryBo();
        orgQryBo.setOrgId(orgId);
        SysOrgInfoDo details = this.iSysOrgInfoModel.getOrgInfoDetails(orgQryBo);
        AuthOtherOrgBo authOtherOrgBo = new AuthOtherOrgBo();
        authOtherOrgBo.setOrgId(details.getOrgId());
        authOtherOrgBo.setOrgName(details.getOrgName());
        authOtherOrgBo.setHasSel(true);
        authOtherOrgBo.setParentId(details.getParentId());
        this.tree.add(authOtherOrgBo);
        if (ObjectUtil.isNotEmpty((Object)details.getParentId())) {
            this.createTree(details.getParentId());
        }
        return this.tree;
    }
}

