/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.role;

import com.tydic.dyc.authority.model.role.ISysRoleInfoModel;
import com.tydic.dyc.authority.model.role.SysRoleInfoDo;
import com.tydic.dyc.authority.model.role.qrybo.SysRoleInfoQryBo;
import com.tydic.dyc.authority.service.domainservice.bo.AuthRoleInfoBo;
import com.tydic.dyc.authority.service.role.AuthDisableRoleInfoService;
import com.tydic.dyc.authority.service.role.bo.AuthDisableRoleInfoReqBo;
import com.tydic.dyc.authority.service.role.bo.AuthDisableRoleInfoRspBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AUTHORITY_CENTER_DEV/2.0.0/com.tydic.dyc.authority.service.role.AuthDisableRoleInfoService"})
public class AuthDisableRoleInfoServiceImpl
implements AuthDisableRoleInfoService {
    @Autowired
    private ISysRoleInfoModel iSysRoleInfoModel;

    @PostMapping(value={"disableRoleInfo"})
    public AuthDisableRoleInfoRspBo disableRoleInfo(@RequestBody AuthDisableRoleInfoReqBo reqBo) {
        AuthDisableRoleInfoRspBo rspBo = AuthRu.success(AuthDisableRoleInfoRspBo.class);
        this.validateArg(reqBo);
        SysRoleInfoQryBo qryBo = new SysRoleInfoQryBo();
        qryBo.setRoleId(reqBo.getRoleId());
        SysRoleInfoDo rspDoDetail = this.iSysRoleInfoModel.getRoleInfoDetails(qryBo);
        if (rspDoDetail == null || rspDoDetail.getRoleId() == null) {
            throw new BaseBusinessException("100001", "\u672a\u67e5\u8be2\u5230\u89d2\u8272\u4fe1\u606f");
        }
        if ("0".equals(rspDoDetail.getRoleStatus())) {
            return rspBo;
        }
        SysRoleInfoDo reqDo = this.buildDoByBO(reqBo);
        SysRoleInfoDo rspDo = this.iSysRoleInfoModel.modifyRoleInfo(reqDo);
        AuthRoleInfoBo DoToBo = AuthRu.js(rspDo, AuthRoleInfoBo.class);
        rspBo.setRoleInfoBo(DoToBo);
        return rspBo;
    }

    private SysRoleInfoDo buildDoByBO(AuthDisableRoleInfoReqBo reqBo) {
        reqBo.setUpdateTime(new Date());
        SysRoleInfoDo reqDo = AuthRu.js(reqBo, SysRoleInfoDo.class);
        reqDo.setRoleStatus("0");
        return reqDo;
    }

    private void validateArg(AuthDisableRoleInfoReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthDeleteRoleInfoReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getRoleId() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[RoleId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

