/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.role;

import com.tydic.dyc.authority.model.common.sub.SysAuthRoleMenuDataOrgSubDo;
import com.tydic.dyc.authority.model.common.sub.SysRoleMenuBtnSubDo;
import com.tydic.dyc.authority.model.menu.ISysMenuModel;
import com.tydic.dyc.authority.model.organization.ISysOrgInfoModel;
import com.tydic.dyc.authority.model.organization.SysOrgInfoDo;
import com.tydic.dyc.authority.model.role.ISysRoleInfoModel;
import com.tydic.dyc.authority.model.role.SysRoleInfoDo;
import com.tydic.dyc.authority.model.role.sub.SysRoleMenuDataAuthSubDo;
import com.tydic.dyc.authority.model.role.sub.SysRoleMenuRelSubDo;
import com.tydic.dyc.authority.service.role.AuthRoleDataPowerSaveService;
import com.tydic.dyc.authority.service.role.bo.AuthRoleDataPowerFuncPowerBo;
import com.tydic.dyc.authority.service.role.bo.AuthRoleDataPowerSaveBo;
import com.tydic.dyc.authority.service.role.bo.AuthRoleDataPowerSaveReqBo;
import com.tydic.dyc.authority.service.role.bo.AuthRoleDataPowerSaveRspBo;
import com.tydic.dyc.authority.utils.IdUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AUTHORITY_CENTER_DEV/2.0.0/com.tydic.dyc.authority.service.role.AuthRoleDataPowerSaveService"})
public class AuthRoleDataPowerSaveServiceImpl
implements AuthRoleDataPowerSaveService {
    @Autowired
    private ISysRoleInfoModel iSysRoleInfoModel;
    @Autowired
    private ISysOrgInfoModel iSysOrgInfoModel;
    @Autowired
    private ISysMenuModel iSysMenuModel;

    @PostMapping(value={"saveRoleDataPower"})
    public AuthRoleDataPowerSaveRspBo saveRoleDataPower(@RequestBody AuthRoleDataPowerSaveReqBo reqBo) {
        AuthRoleDataPowerSaveRspBo rspBo = new AuthRoleDataPowerSaveRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        this.validata(reqBo);
        ArrayList<Long> menuList = new ArrayList<Long>();
        HashSet<Long> orgIds = new HashSet<Long>();
        ArrayList<SysRoleMenuRelSubDo> insertMenus = new ArrayList<SysRoleMenuRelSubDo>();
        ArrayList<SysRoleMenuBtnSubDo> insertBtns = new ArrayList<SysRoleMenuBtnSubDo>();
        ArrayList<SysRoleMenuDataAuthSubDo> insertAuth = new ArrayList<SysRoleMenuDataAuthSubDo>();
        ArrayList<SysAuthRoleMenuDataOrgSubDo> insertOrg = new ArrayList<SysAuthRoleMenuDataOrgSubDo>();
        for (AuthRoleDataPowerSaveBo dataPowerSaveBo : reqBo.getMenuDataPowerList()) {
            menuList.add(dataPowerSaveBo.getMenuBo().getMenuId());
            if (!dataPowerSaveBo.getMenuBo().getHasSel().booleanValue()) continue;
            this.delBtn(reqBo, insertBtns, dataPowerSaveBo);
            this.delAuthDataOrg(reqBo, orgIds, insertAuth, insertOrg, dataPowerSaveBo);
            this.delMenu(reqBo, insertMenus, dataPowerSaveBo);
        }
        this.getOrgTreePath(orgIds, insertOrg);
        if (!CollectionUtils.isEmpty(menuList)) {
            this.deleteMenuRole(reqBo, menuList);
            SysRoleInfoDo deleteRoleMenuBtnDo = new SysRoleInfoDo();
            deleteRoleMenuBtnDo.setRoleId(reqBo.getRoleId());
            deleteRoleMenuBtnDo.setMenuIds(menuList);
            this.iSysRoleInfoModel.deleteRoleMenuBtnByRole(deleteRoleMenuBtnDo);
            this.iSysRoleInfoModel.deleteRoleMenuDataOrg(deleteRoleMenuBtnDo);
            this.iSysRoleInfoModel.deleteRoleMenuDataAuth(deleteRoleMenuBtnDo);
        }
        if (!CollectionUtils.isEmpty(insertMenus)) {
            SysRoleInfoDo insertRoleMenuRelDo = new SysRoleInfoDo();
            insertRoleMenuRelDo.setMenuRelList(insertMenus);
            this.iSysRoleInfoModel.addRoleMenuRel(insertRoleMenuRelDo);
        }
        if (!CollectionUtils.isEmpty(insertBtns)) {
            SysRoleInfoDo insertBtnsDo = new SysRoleInfoDo();
            insertBtnsDo.setRoleMenuBtnList(insertBtns);
            this.iSysRoleInfoModel.addRoleMenuBtn(insertBtnsDo);
        }
        if (!CollectionUtils.isEmpty(insertAuth)) {
            SysRoleInfoDo insertAuthsDo = new SysRoleInfoDo();
            insertAuthsDo.setRoleMenuDataAuths(insertAuth);
            this.iSysRoleInfoModel.addRoleMenuDataAuth(insertAuthsDo);
        }
        if (!CollectionUtils.isEmpty(insertOrg)) {
            SysRoleInfoDo insertOrgsDo = new SysRoleInfoDo();
            insertOrgsDo.setAuthRoleMenuDataOrgList(insertOrg);
            this.iSysRoleInfoModel.addRoleMenuDataOrg(insertOrgsDo);
        }
        return rspBo;
    }

    private void deleteMenuRole(AuthRoleDataPowerSaveReqBo reqBo, List<Long> menuList) {
        SysRoleInfoDo deleteMenuDo = new SysRoleInfoDo();
        ArrayList<SysRoleMenuRelSubDo> deleteMenuSubDo = new ArrayList<SysRoleMenuRelSubDo>();
        for (Long menuId : menuList) {
            SysRoleMenuRelSubDo subDo = new SysRoleMenuRelSubDo();
            subDo.setRoleId(reqBo.getRoleId());
            subDo.setMenuId(menuId);
            subDo.setDelFlag("1");
            deleteMenuSubDo.add(subDo);
        }
        deleteMenuDo.setMenuRelList(deleteMenuSubDo);
        this.iSysRoleInfoModel.updateRoleMenuRel(deleteMenuDo);
    }

    private void getOrgTreePath(Set<Long> orgIds, List<SysAuthRoleMenuDataOrgSubDo> insertOrg) {
        if (!CollectionUtils.isEmpty(orgIds) && !CollectionUtils.isEmpty(insertOrg)) {
            ArrayList<Long> queryOrgIds = new ArrayList<Long>(orgIds);
            SysOrgInfoDo queryOrgInfoDo = new SysOrgInfoDo();
            queryOrgInfoDo.setOrgIds(queryOrgIds);
            List orgList = this.iSysOrgInfoModel.getList(queryOrgInfoDo).getRows();
            if (!CollectionUtils.isEmpty((Collection)orgList)) {
                Map orgMap = orgList.stream().collect(Collectors.toMap(SysOrgInfoDo::getOrgId, Function.identity(), (e1, e2) -> e2));
                for (SysAuthRoleMenuDataOrgSubDo subDo : insertOrg) {
                    if (!orgMap.containsKey(subDo.getOrgId())) continue;
                    subDo.setOrgTreePath(((SysOrgInfoDo)orgMap.get(subDo.getOrgId())).getOrgTreePath());
                }
            }
        }
    }

    private void delMenu(AuthRoleDataPowerSaveReqBo reqBo, List<SysRoleMenuRelSubDo> insertMenus, AuthRoleDataPowerSaveBo dataPowerSaveBo) {
        SysRoleMenuRelSubDo menuRelSubDo = new SysRoleMenuRelSubDo();
        menuRelSubDo.setMenuId(dataPowerSaveBo.getMenuBo().getMenuId());
        menuRelSubDo.setRoleId(reqBo.getRoleId());
        menuRelSubDo.setRelId(IdUtil.nextId());
        menuRelSubDo.setCreateOperId(reqBo.getUserIdIn());
        menuRelSubDo.setCreateOperName(reqBo.getCustNameIn());
        menuRelSubDo.setCreateTime(new Date());
        menuRelSubDo.setUpdateOperId(reqBo.getUserIdIn());
        menuRelSubDo.setUpdateOperName(reqBo.getCustNameIn());
        menuRelSubDo.setUpdateTime(new Date());
        menuRelSubDo.setDelFlag("0");
        insertMenus.add(menuRelSubDo);
    }

    private void delAuthDataOrg(AuthRoleDataPowerSaveReqBo reqBo, Set<Long> orgIds, List<SysRoleMenuDataAuthSubDo> insertAuth, List<SysAuthRoleMenuDataOrgSubDo> insertOrg, AuthRoleDataPowerSaveBo dataPowerSaveBo) {
        if (dataPowerSaveBo.getDataPowerBo() != null) {
            SysRoleMenuDataAuthSubDo dataAuthSubDo;
            if (dataPowerSaveBo.getDataPowerBo().getOrgHasSel().booleanValue() && !StringUtils.isEmpty((Object)dataPowerSaveBo.getDataPowerBo().getOrgSelValue())) {
                dataAuthSubDo = new SysRoleMenuDataAuthSubDo();
                dataAuthSubDo.setDataAuthId(IdUtil.nextId());
                dataAuthSubDo.setDataAuthItem("0");
                dataAuthSubDo.setDataAuthItemSub(dataPowerSaveBo.getDataPowerBo().getOrgSelValue());
                dataAuthSubDo.setRoleId(reqBo.getRoleId());
                dataAuthSubDo.setMenuId(dataPowerSaveBo.getMenuBo().getMenuId());
                dataAuthSubDo.setCreateOperId(reqBo.getUserIdIn());
                dataAuthSubDo.setCreateOperName(reqBo.getCustNameIn());
                dataAuthSubDo.setCreateTime(new Date());
                dataAuthSubDo.setUpdateOperId(reqBo.getUserIdIn());
                dataAuthSubDo.setUpdateOperName(reqBo.getCustNameIn());
                dataAuthSubDo.setUpdateTime(new Date());
                dataAuthSubDo.setDelFlag("0");
                insertAuth.add(dataAuthSubDo);
            }
            if (dataPowerSaveBo.getDataPowerBo().getOtherOrgHasSel().booleanValue() && !CollectionUtils.isEmpty((Collection)dataPowerSaveBo.getDataPowerBo().getOtherOrgSelValueList())) {
                dataAuthSubDo = new SysRoleMenuDataAuthSubDo();
                dataAuthSubDo.setDataAuthId(IdUtil.nextId());
                dataAuthSubDo.setDataAuthItem("1");
                dataAuthSubDo.setRoleId(reqBo.getRoleId());
                dataAuthSubDo.setMenuId(dataPowerSaveBo.getMenuBo().getMenuId());
                dataAuthSubDo.setCreateOperId(reqBo.getUserIdIn());
                dataAuthSubDo.setCreateOperName(reqBo.getCustNameIn());
                dataAuthSubDo.setCreateTime(new Date());
                dataAuthSubDo.setUpdateOperId(reqBo.getUserIdIn());
                dataAuthSubDo.setUpdateOperName(reqBo.getCustNameIn());
                dataAuthSubDo.setUpdateTime(new Date());
                dataAuthSubDo.setDelFlag("0");
                insertAuth.add(dataAuthSubDo);
                orgIds.addAll(dataPowerSaveBo.getDataPowerBo().getOtherOrgSelValueList());
                for (Long orgId : dataPowerSaveBo.getDataPowerBo().getOtherOrgSelValueList()) {
                    SysAuthRoleMenuDataOrgSubDo orgSubDo = new SysAuthRoleMenuDataOrgSubDo();
                    orgSubDo.setDataAuthId(dataAuthSubDo.getDataAuthId());
                    orgSubDo.setRoleId(reqBo.getRoleId());
                    orgSubDo.setOrgExtend(0);
                    orgSubDo.setId(IdUtil.nextId());
                    orgSubDo.setOrgId(orgId);
                    orgSubDo.setMenuId(dataPowerSaveBo.getMenuBo().getMenuId());
                    orgSubDo.setCreateOperId(reqBo.getUserIdIn());
                    orgSubDo.setCreateOperName(reqBo.getCustNameIn());
                    orgSubDo.setCreateTime(new Date());
                    orgSubDo.setUpdateOperId(reqBo.getUserIdIn());
                    orgSubDo.setUpdateOperName(reqBo.getCustNameIn());
                    orgSubDo.setUpdateTime(new Date());
                    orgSubDo.setDelFlag("0");
                    insertOrg.add(orgSubDo);
                }
            }
        }
    }

    private void delBtn(AuthRoleDataPowerSaveReqBo reqBo, List<SysRoleMenuBtnSubDo> insertBtns, AuthRoleDataPowerSaveBo dataPowerSaveBo) {
        if (!CollectionUtils.isEmpty((Collection)dataPowerSaveBo.getFuncPowerBoList())) {
            for (AuthRoleDataPowerFuncPowerBo funcPowerBo : dataPowerSaveBo.getFuncPowerBoList()) {
                SysRoleMenuBtnSubDo menuBtnSubDo = new SysRoleMenuBtnSubDo();
                menuBtnSubDo.setBtnCode(funcPowerBo.getBtnCode());
                menuBtnSubDo.setBtnName(funcPowerBo.getBtnName());
                menuBtnSubDo.setRoleId(reqBo.getRoleId());
                menuBtnSubDo.setMenuId(dataPowerSaveBo.getMenuBo().getMenuId());
                menuBtnSubDo.setId(IdUtil.nextId());
                menuBtnSubDo.setCreateOperId(reqBo.getUserIdIn());
                menuBtnSubDo.setCreateOperName(reqBo.getCustNameIn());
                menuBtnSubDo.setCreateTime(new Date());
                menuBtnSubDo.setUpdateOperId(reqBo.getUserIdIn());
                menuBtnSubDo.setUpdateOperName(reqBo.getCustNameIn());
                menuBtnSubDo.setUpdateTime(new Date());
                menuBtnSubDo.setDelFlag("0");
                insertBtns.add(menuBtnSubDo);
            }
        }
    }

    private void validata(AuthRoleDataPowerSaveReqBo reqBo) {
        if (reqBo.getRoleId() == null) {
            throw new BaseBusinessException("100001", "\u89d2\u8272ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getMenuDataPowerList())) {
            throw new BaseBusinessException("100001", "\u6743\u9650\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getUserIdIn() == null) {
            throw new BaseBusinessException("100001", "\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getCustNameIn())) {
            throw new BaseBusinessException("100001", "\u5ba2\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (AuthRoleDataPowerSaveBo saveBo : reqBo.getMenuDataPowerList()) {
            if (saveBo.getMenuBo() != null && saveBo.getMenuBo().getMenuId() != null && saveBo.getMenuBo().getHasSel() != null) continue;
            throw new BaseBusinessException("100001", "\u83dc\u5355\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

