/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.user;

import com.tydic.dyc.authority.model.common.sub.SysAuthDistributeSubDo;
import com.tydic.dyc.authority.model.organization.ISysOrgInfoModel;
import com.tydic.dyc.authority.model.organization.SysOrgInfoDo;
import com.tydic.dyc.authority.model.organization.qrybo.SysOrgInfoQryBo;
import com.tydic.dyc.authority.model.user.ISysUserInfoModel;
import com.tydic.dyc.authority.model.user.SysUserInfoDo;
import com.tydic.dyc.authority.model.user.qrybo.SysUserInfoQryBo;
import com.tydic.dyc.authority.model.user.qrybo.SysUserTagRelQryBo;
import com.tydic.dyc.authority.model.user.sub.SysUserChngLogSubDo;
import com.tydic.dyc.authority.model.user.sub.SysUserTagRelSubDo;
import com.tydic.dyc.authority.service.domainservice.bo.AuthDistributeBo;
import com.tydic.dyc.authority.service.user.AuthDealUserJobMobilityService;
import com.tydic.dyc.authority.service.user.bo.AuthDealUserJobMobilityReqBo;
import com.tydic.dyc.authority.service.user.bo.AuthDealUserJobMobilityRspBo;
import com.tydic.dyc.authority.service.user.bo.AuthUserInfoBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.authority.utils.IdUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AUTHORITY_CENTER_DEV/2.0.0/com.tydic.dyc.authority.service.user.AuthDealUserJobMobilityService"})
public class AuthDealUserJobMobilityServiceImpl
implements AuthDealUserJobMobilityService {
    @Autowired
    private ISysUserInfoModel iSysUserInfoModel;
    @Autowired
    private ISysOrgInfoModel iSysOrgInfoModel;

    @PostMapping(value={"dealUserJobMobility"})
    public AuthDealUserJobMobilityRspBo dealUserJobMobility(@RequestBody AuthDealUserJobMobilityReqBo reqBo) {
        AuthDealUserJobMobilityRspBo rspBo = AuthRu.success(AuthDealUserJobMobilityRspBo.class);
        this.validateArg(reqBo);
        SysUserInfoQryBo qryBo = new SysUserInfoQryBo();
        qryBo.setUserId(reqBo.getUserId());
        SysUserInfoDo oldDetailDo = this.iSysUserInfoModel.getUserInfoDetails(qryBo);
        if (oldDetailDo == null || oldDetailDo.getUserId() == null) {
            throw new BaseBusinessException("100001", "\u672a\u67e5\u8be2\u5230\u7528\u6237\u4fe1\u606f");
        }
        SysOrgInfoQryBo orgInfoQryBo = new SysOrgInfoQryBo();
        orgInfoQryBo.setOrgId(reqBo.getNewOrgId());
        SysOrgInfoDo orgInfoDo = this.iSysOrgInfoModel.getOrgInfoDetails(orgInfoQryBo);
        if (orgInfoDo == null || orgInfoDo.getOrgId() == null) {
            throw new BaseBusinessException("100001", "\u672a\u67e5\u8be2\u5230\u673a\u6784\u4fe1\u606f");
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getAuthDistributeList())) {
            SysUserInfoQryBo qryRoleDo = new SysUserInfoQryBo();
            qryRoleDo.setUserId(reqBo.getUserId());
            SysUserInfoDo roleDo = this.iSysUserInfoModel.getRoleInfoListByUser(qryRoleDo);
            if (!CollectionUtils.isEmpty(roleDo.getUserRoleList())) {
                oldDetailDo.setUserRoleList(roleDo.getUserRoleList());
                oldDetailDo.setAuthDistributeList(AuthRu.jsl(roleDo.getUserRoleList(), SysAuthDistributeSubDo.class));
            }
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getUserTagRelList())) {
            SysUserTagRelQryBo tagQryBo = new SysUserTagRelQryBo();
            tagQryBo.setUserId(reqBo.getUserId());
            SysUserInfoDo sysUserInfoDo = this.iSysUserInfoModel.getUserTagList(tagQryBo);
            List<SysUserTagRelSubDo> tagDo = sysUserInfoDo.getUserTagRelList();
            oldDetailDo.setUserTagRelList(tagDo);
        }
        SysUserInfoDo reqDo = this.buildDo(reqBo, oldDetailDo);
        reqDo.setOrgTreePath(orgInfoDo.getOrgTreePath());
        SysUserInfoDo rspDo = this.iSysUserInfoModel.createUserInfo(reqDo);
        if (!CollectionUtils.isEmpty(reqDo.getAuthDistributeList())) {
            this.iSysUserInfoModel.addUserRoleList(reqDo);
        }
        SysUserInfoDo reqDelDo = this.buildDelDo(reqBo);
        this.iSysUserInfoModel.modifyUserInfo(reqDelDo);
        SysUserChngLogSubDo chngLogDo = this.chngLogDo(reqBo, reqDo, oldDetailDo);
        this.iSysUserInfoModel.addUserChngLog(chngLogDo);
        AuthUserInfoBo DoToBo = AuthRu.js(rspDo, AuthUserInfoBo.class);
        rspBo.setUserInfoBo(DoToBo);
        return rspBo;
    }

    private SysUserInfoDo buildDo(AuthDealUserJobMobilityReqBo reqBo, SysUserInfoDo oldDetailDo) {
        SysUserInfoDo reqDo = AuthRu.js(oldDetailDo, SysUserInfoDo.class);
        reqDo.setUserId(IdUtil.nextId());
        reqDo.setOrgId(reqBo.getNewOrgId());
        reqDo.setCreateOperId(reqBo.getCreateOperId());
        reqDo.setCreateOperName(reqBo.getCreateOperName());
        reqDo.setCreateTime(reqBo.getCreateTime());
        reqDo.setUpdateOperId(reqBo.getUpdateOperId());
        reqDo.setUpdateOperName(reqBo.getCreateOperName());
        reqDo.setUpdateTime(reqBo.getCreateTime());
        if (!CollectionUtils.isEmpty(oldDetailDo.getUserTagRelList())) {
            ArrayList<SysUserTagRelSubDo> sysUserTagRelList = new ArrayList<SysUserTagRelSubDo>();
            for (SysUserTagRelSubDo sysUserTagRelSubDo : oldDetailDo.getUserTagRelList()) {
                sysUserTagRelSubDo.setRelId(IdUtil.nextId());
                sysUserTagRelSubDo.setUserId(reqDo.getUserId());
                sysUserTagRelSubDo.setCreateOperId(reqDo.getCreateOperId());
                sysUserTagRelSubDo.setCreateOperName(reqDo.getCreateOperName());
                sysUserTagRelSubDo.setCreateTime(reqDo.getCreateTime());
                sysUserTagRelSubDo.setUpdateOperId(reqDo.getUpdateOperId());
                sysUserTagRelSubDo.setUpdateOperName(reqDo.getCreateOperName());
                sysUserTagRelSubDo.setUpdateTime(reqDo.getCreateTime());
                sysUserTagRelList.add(sysUserTagRelSubDo);
            }
            reqDo.setUserTagRelList(sysUserTagRelList);
        }
        if (!CollectionUtils.isEmpty(oldDetailDo.getAuthDistributeList())) {
            ArrayList<SysAuthDistributeSubDo> authDistributeList = new ArrayList<SysAuthDistributeSubDo>();
            for (SysAuthDistributeSubDo sysAuthDistributeSubDo : oldDetailDo.getAuthDistributeList()) {
                sysAuthDistributeSubDo.setAuthId(IdUtil.nextId());
                sysAuthDistributeSubDo.setUserId(reqDo.getUserId());
                sysAuthDistributeSubDo.setCreateOperId(reqDo.getCreateOperId());
                sysAuthDistributeSubDo.setCreateOperName(reqDo.getCreateOperName());
                sysAuthDistributeSubDo.setCreateTime(reqDo.getCreateTime());
                sysAuthDistributeSubDo.setUpdateOperId(reqDo.getUpdateOperId());
                sysAuthDistributeSubDo.setUpdateOperName(reqDo.getCreateOperName());
                sysAuthDistributeSubDo.setUpdateTime(reqDo.getCreateTime());
                authDistributeList.add(sysAuthDistributeSubDo);
            }
            reqDo.setAuthDistributeList(authDistributeList);
        }
        reqDo.setCustInfo(null);
        reqDo.setCustExtMapList(null);
        return reqDo;
    }

    private SysUserChngLogSubDo chngLogDo(AuthDealUserJobMobilityReqBo reqBo, SysUserInfoDo newDo, SysUserInfoDo oldDo) {
        SysUserChngLogSubDo reqDo = AuthRu.js(reqBo, SysUserChngLogSubDo.class);
        reqDo.setLogId(IdUtil.nextId());
        reqDo.setCurrentOrgId(reqBo.getNewOrgId());
        reqDo.setOldOrgId(oldDo.getOrgId());
        reqDo.setChangeTime(reqBo.getUpdateTime());
        reqDo.setOldOrgId(oldDo.getOrgId());
        reqDo.setCustId(newDo.getCustId());
        reqDo.setMainCustId(newDo.getMainCustId());
        reqDo.setChangeType("2");
        reqDo.setCreateOperId(reqBo.getCreateOperId());
        reqDo.setCreateOperName(reqBo.getCreateOperName());
        reqDo.setCreateTime(reqBo.getCreateTime());
        reqDo.setUpdateOperId(reqBo.getUpdateOperId());
        reqDo.setUpdateOperName(reqBo.getCreateOperName());
        reqDo.setUpdateTime(reqBo.getCreateTime());
        return reqDo;
    }

    private SysUserInfoDo buildDelDo(AuthDealUserJobMobilityReqBo reqBo) {
        reqBo.setUpdateTime(reqBo.getUpdateTime());
        SysUserInfoDo reqDo = AuthRu.js(reqBo, SysUserInfoDo.class);
        reqDo.setUserStatus("0");
        return reqDo;
    }

    private void validateArg(AuthDealUserJobMobilityReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthCreateRoleInfoReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getUserId() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[UserId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getNewOrgId() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[NewOrgId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getAuthDistributeList())) {
            for (AuthDistributeBo bo : reqBo.getAuthDistributeList()) {
                if (bo.getRoleId() != null) continue;
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[RoleId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getUserTagRelList())) {
            for (AuthDistributeBo bo : reqBo.getUserTagRelList()) {
                if (bo.getTagId() != null) continue;
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[TagId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }
}

