/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.domainservice;

import com.tydic.dyc.authority.model.loginlog.ISysLoginLogModel;
import com.tydic.dyc.authority.model.loginlog.SysLoginLogDo;
import com.tydic.dyc.authority.model.user.ISysUserInfoModel;
import com.tydic.dyc.authority.model.user.SysUserInfoDo;
import com.tydic.dyc.authority.model.user.qrybo.SysCustExtMapQryBo;
import com.tydic.dyc.authority.model.user.sub.SysCustExtMapSubDo;
import com.tydic.dyc.authority.service.domainservice.AuthCreateLoginLogService;
import com.tydic.dyc.authority.service.domainservice.bo.AuthCreateLoginLogReqBo;
import com.tydic.dyc.authority.service.domainservice.bo.AuthCreateLoginLogRspBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.authority.utils.IdUtil;
import com.tydic.dyc.authority.utils.StrUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AUTHORITY_CENTER_DEV/2.0.0/com.tydic.dyc.authority.service.domainservice.AuthCreateLoginLogService"})
public class AuthCreateLoginLogServiceImpl
implements AuthCreateLoginLogService {
    @Autowired
    private ISysUserInfoModel iSysUserInfoModel;
    @Autowired
    private ISysLoginLogModel iSysLoginLogModel;

    @PostMapping(value={"createLoginLog"})
    public AuthCreateLoginLogRspBo createLoginLog(@RequestBody AuthCreateLoginLogReqBo reqBo) {
        AuthCreateLoginLogRspBo rspBo = AuthRu.success(AuthCreateLoginLogRspBo.class);
        this.validateArg(reqBo);
        SysLoginLogDo reqDo = this.buildDoByBO(reqBo);
        SysLoginLogDo rspDo = this.iSysLoginLogModel.createLoginLog(StrUtil.noNullStringAttr(reqDo));
        ArrayList<String> extFieldCodes = new ArrayList<String>();
        extFieldCodes.add("lastLoginTime");
        extFieldCodes.add("currentLoginTime");
        SysCustExtMapQryBo extMapQryBo = new SysCustExtMapQryBo();
        extMapQryBo.setCustId(reqBo.getCustId());
        extMapQryBo.setFieldCodes(extFieldCodes);
        SysUserInfoDo sysUserInfoDo = this.iSysUserInfoModel.getCustExtMapList(extMapQryBo);
        List<SysCustExtMapSubDo> extMapList = sysUserInfoDo.getCustExtMapList();
        ArrayList<SysCustExtMapSubDo> updateList = new ArrayList<SysCustExtMapSubDo>();
        ArrayList<SysCustExtMapSubDo> addList = new ArrayList<SysCustExtMapSubDo>();
        this.buildExtMapDo(reqBo, extMapList, addList, updateList);
        this.addCustExtMap(addList);
        this.updateCustExtMap(updateList);
        return rspBo;
    }

    private SysLoginLogDo buildDoByBO(AuthCreateLoginLogReqBo reqBo) {
        Date loginDate = new Date();
        SimpleDateFormat dataFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String loginDateStr = dataFormat.format(loginDate);
        reqBo.setCreateTime(loginDate);
        reqBo.setLoginTime(loginDateStr);
        reqBo.setLogId(Long.valueOf(IdUtil.nextId()));
        return AuthRu.js(reqBo, SysLoginLogDo.class);
    }

    private void buildExtMapDo(AuthCreateLoginLogReqBo reqBo, List<SysCustExtMapSubDo> extMapList, List<SysCustExtMapSubDo> addList, List<SysCustExtMapSubDo> updateList) {
        SysCustExtMapSubDo lastLoginTimeDo = new SysCustExtMapSubDo();
        SysCustExtMapSubDo currentLoginTimeDo = new SysCustExtMapSubDo();
        String lastLoginTime = null;
        for (SysCustExtMapSubDo extSubDo : extMapList) {
            if ("lastLoginTime".equals(extSubDo.getFieldCode())) {
                lastLoginTimeDo = AuthRu.js(extSubDo, SysCustExtMapSubDo.class);
            }
            if (!"currentLoginTime".equals(extSubDo.getFieldCode())) continue;
            currentLoginTimeDo = AuthRu.js(extSubDo, SysCustExtMapSubDo.class);
            lastLoginTime = currentLoginTimeDo.getFieldValue();
        }
        if (StringUtils.isBlank(lastLoginTime)) {
            lastLoginTime = reqBo.getLoginTime();
        }
        String currentLoginTime = reqBo.getLoginTime();
        if (lastLoginTimeDo.getExtId() == null) {
            lastLoginTimeDo.setExtId(IdUtil.nextId());
            lastLoginTimeDo.setCustId(reqBo.getCustId());
            lastLoginTimeDo.setTenantId(reqBo.getTenantId());
            lastLoginTimeDo.setFieldCode("lastLoginTime");
            lastLoginTimeDo.setFieldName("\u4e0a\u6b21\u767b\u5f55\u65f6\u95f4");
            lastLoginTimeDo.setFieldValue(lastLoginTime);
            lastLoginTimeDo.setCreateOperId(reqBo.getCreateOperId());
            lastLoginTimeDo.setCreateOperName(reqBo.getCreateOperName());
            lastLoginTimeDo.setCreateTime(new Date());
            lastLoginTimeDo.setUpdateOperId(reqBo.getCreateOperId());
            lastLoginTimeDo.setUpdateOperName(reqBo.getCreateOperName());
            lastLoginTimeDo.setUpdateTime(new Date());
            lastLoginTimeDo.setDelFlag("0");
            addList.add(lastLoginTimeDo);
        } else {
            lastLoginTimeDo.setFieldValue(lastLoginTime);
            updateList.add(lastLoginTimeDo);
        }
        if (currentLoginTimeDo.getExtId() == null) {
            currentLoginTimeDo.setExtId(IdUtil.nextId());
            currentLoginTimeDo.setCustId(reqBo.getCustId());
            currentLoginTimeDo.setTenantId(reqBo.getTenantId());
            currentLoginTimeDo.setFieldCode("currentLoginTime");
            currentLoginTimeDo.setFieldName("\u672c\u6b21\u767b\u5f55\u65f6\u95f4");
            currentLoginTimeDo.setFieldValue(currentLoginTime);
            currentLoginTimeDo.setCreateOperId(reqBo.getCreateOperId());
            currentLoginTimeDo.setCreateOperName(reqBo.getCreateOperName());
            currentLoginTimeDo.setCreateTime(new Date());
            currentLoginTimeDo.setUpdateOperId(reqBo.getCreateOperId());
            currentLoginTimeDo.setUpdateOperName(reqBo.getCreateOperName());
            currentLoginTimeDo.setUpdateTime(new Date());
            currentLoginTimeDo.setDelFlag("0");
            addList.add(currentLoginTimeDo);
        } else {
            currentLoginTimeDo.setFieldValue(currentLoginTime);
            updateList.add(currentLoginTimeDo);
        }
    }

    private void validateArg(AuthCreateLoginLogReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthCreateLoginLogReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void addCustExtMap(List<SysCustExtMapSubDo> addCustExtMapList) {
        SysUserInfoDo addReqBo = new SysUserInfoDo();
        addReqBo.setCustExtMapList(addCustExtMapList);
        this.iSysUserInfoModel.addCustExtMapList(addReqBo);
    }

    private void updateCustExtMap(List<SysCustExtMapSubDo> updateCustExtMapList) {
        SysUserInfoDo addReqBo = new SysUserInfoDo();
        addReqBo.setCustExtMapList(updateCustExtMapList);
        this.iSysUserInfoModel.updateCustExtMapList(addReqBo);
    }
}

