/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.tenant;

import com.tydic.dyc.authority.model.tenant.ISysTenantModel;
import com.tydic.dyc.authority.model.tenant.SysTenantInfoDo;
import com.tydic.dyc.authority.model.tenant.qrybo.SysTenantInfoQryBo;
import com.tydic.dyc.authority.service.tenant.AuthDeleteTenantInfoService;
import com.tydic.dyc.authority.service.tenant.bo.AuthDeleteTenantInfoReqBo;
import com.tydic.dyc.authority.service.tenant.bo.AuthDeleteTenantInfoRspBo;
import com.tydic.dyc.authority.service.tenant.bo.AuthTenantInfoBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;

public class AuthDeleteTenantInfoServiceImpl
implements AuthDeleteTenantInfoService {
    @Autowired
    private ISysTenantModel iSysTenantModel;

    public AuthDeleteTenantInfoRspBo deleteTenantInfo(AuthDeleteTenantInfoReqBo reqBo) {
        AuthDeleteTenantInfoRspBo rspBo = AuthRu.success(AuthDeleteTenantInfoRspBo.class);
        this.validateArg(reqBo);
        SysTenantInfoQryBo qryBo = new SysTenantInfoQryBo();
        qryBo.setTenantId(reqBo.getTenantId());
        SysTenantInfoDo rspDoDetail = this.iSysTenantModel.getTenantInfoDetails(qryBo);
        if (rspDoDetail == null || rspDoDetail.getTenantId() == null) {
            throw new BaseBusinessException("100001", "\u672a\u67e5\u8be2\u5230\u79df\u6237\u4fe1\u606f");
        }
        if ("1".equals(rspDoDetail.getDelFlag())) {
            return rspBo;
        }
        SysTenantInfoDo reqDo = this.buildDoByBO(reqBo);
        SysTenantInfoDo rspDo = this.iSysTenantModel.modifyTenantInfo(reqDo);
        AuthTenantInfoBo DoToBo = AuthRu.js(rspDo, AuthTenantInfoBo.class);
        return rspBo;
    }

    private SysTenantInfoDo buildDoByBO(AuthDeleteTenantInfoReqBo reqBo) {
        reqBo.setUpdateTime(new Date());
        SysTenantInfoDo reqDo = AuthRu.js(reqBo, SysTenantInfoDo.class);
        reqDo.setDelFlag("1");
        return reqDo;
    }

    private void validateArg(AuthDeleteTenantInfoReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthCreateTenantInfoReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getTenantId() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[TenantId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

