/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.menu;

import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.authority.model.menu.ISysMenuModel;
import com.tydic.dyc.authority.model.menu.SysMenuDo;
import com.tydic.dyc.authority.model.menu.qrybo.SysMenuQryBo;
import com.tydic.dyc.authority.model.subpage.ISysSubpageModel;
import com.tydic.dyc.authority.model.subpage.qrybo.SysSubpageQryBo;
import com.tydic.dyc.authority.model.subpage.qrybo.SysSubpageRspBo;
import com.tydic.dyc.authority.service.menu.AuthModifyMenuService;
import com.tydic.dyc.authority.service.menu.bo.AuthMenuInfoBo;
import com.tydic.dyc.authority.service.menu.bo.AuthModifyMenuReqBo;
import com.tydic.dyc.authority.service.menu.bo.AuthModifyMenuRspBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.authority.utils.StrUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AUTHORITY_CENTER_DEV/2.0.0/com.tydic.dyc.authority.service.menu.AuthModifyMenuService"})
public class AuthModifyMenuServiceImpl
implements AuthModifyMenuService {
    private static final Logger log = LoggerFactory.getLogger(AuthModifyMenuServiceImpl.class);
    @Autowired
    private ISysMenuModel iSysMenuModel;
    @Autowired
    private ISysSubpageModel iSysSubpageModel;

    @PostMapping(value={"modifyMenu"})
    public AuthModifyMenuRspBo modifyMenu(@RequestBody AuthModifyMenuReqBo reqBo) {
        AuthModifyMenuRspBo rspBo = AuthRu.success(AuthModifyMenuRspBo.class);
        this.validateArg(reqBo);
        SysMenuDo reqDo = this.buildDoByBO(reqBo);
        if (!StringUtils.isBlank((CharSequence)reqBo.getMenuCode())) {
            log.info("modifyMenu reqBo={}", (Object)JSONObject.toJSONString((Object)reqBo));
            SysSubpageQryBo pageQryBo = new SysSubpageQryBo();
            pageQryBo.setPageCode(reqBo.getMenuCode());
            SysSubpageRspBo subpageList = this.iSysSubpageModel.getSubpageList(pageQryBo);
            if (!CollectionUtils.isEmpty((Collection)subpageList.getRows())) {
                throw new BaseBusinessException("100001", "\u5b50\u9875\u9762\u7f16\u7801\u4e0d\u80fd\u91cd\u590d");
            }
        }
        SysMenuQryBo qryBo = new SysMenuQryBo();
        qryBo.setMenuId(reqBo.getMenuId());
        SysMenuDo detailDo = this.iSysMenuModel.getMenuInfoDetails(qryBo);
        if (detailDo == null || detailDo.getMenuId() == null) {
            throw new BaseBusinessException("100001", "\u672a\u67e5\u8be2\u5230\u83dc\u5355\u4fe1\u606f");
        }
        reqDo.setMenuId(reqBo.getMenuId());
        SysMenuDo rspDo = this.iSysMenuModel.modifyMenuInfo(reqDo);
        AuthMenuInfoBo menuInfoBo = AuthRu.js(rspDo, AuthMenuInfoBo.class);
        rspBo.setMenuInfoBo(menuInfoBo);
        return rspBo;
    }

    private SysMenuDo buildDoByBO(AuthModifyMenuReqBo reqBo) {
        reqBo.setUpdateTime(new Date());
        SysMenuDo reqDo = StrUtil.noNullStringAttr(AuthRu.js(reqBo, SysMenuDo.class));
        return reqDo;
    }

    private void validateArg(AuthModifyMenuReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthCreateMenuReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getMenuId() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[MenuId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

