/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.role;

import com.tydic.dyc.authority.constants.AuthDicConstant;
import com.tydic.dyc.authority.model.common.sub.SysAuthDistributeSubDo;
import com.tydic.dyc.authority.model.role.ISysRoleInfoModel;
import com.tydic.dyc.authority.model.role.SysRoleInfoDo;
import com.tydic.dyc.authority.service.domainservice.bo.AuthDistributeBo;
import com.tydic.dyc.authority.service.role.AuthDealRoleOrgListService;
import com.tydic.dyc.authority.service.role.bo.AuthDealRoleOrgListReqBo;
import com.tydic.dyc.authority.service.role.bo.AuthDealRoleOrgListRspBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.authority.utils.IdUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AUTHORITY_CENTER_DEV/2.0.0/com.tydic.dyc.authority.service.role.AuthDealRoleOrgListService"})
public class AuthDealRoleOrgListServiceImpl
implements AuthDealRoleOrgListService {
    @Autowired
    private ISysRoleInfoModel iSysRoleInfoModel;

    @PostMapping(value={"dealRoleOrgList"})
    public AuthDealRoleOrgListRspBo dealRoleOrgList(@RequestBody AuthDealRoleOrgListReqBo reqBo) {
        AuthDealRoleOrgListRspBo rspBo = AuthRu.success(AuthDealRoleOrgListRspBo.class);
        if (CollectionUtils.isEmpty((Collection)reqBo.getAuthDistributeList())) {
            return rspBo;
        }
        this.validateArg(reqBo);
        SysRoleInfoDo reqDo = AuthRu.js(reqBo, SysRoleInfoDo.class);
        ArrayList<SysAuthDistributeSubDo> addList = new ArrayList<SysAuthDistributeSubDo>();
        ArrayList<SysAuthDistributeSubDo> delList = new ArrayList<SysAuthDistributeSubDo>();
        for (AuthDistributeBo bo : reqBo.getAuthDistributeList()) {
            if ("1".equals(bo.getOperType())) {
                addList.add(AuthRu.js(bo, SysAuthDistributeSubDo.class));
                continue;
            }
            if (!"2".equals(bo.getOperType())) continue;
            delList.add(AuthRu.js(bo, SysAuthDistributeSubDo.class));
        }
        this.deleteRolePower(reqDo, delList);
        this.addRolePower(reqDo, addList);
        return rspBo;
    }

    private void addRolePower(SysRoleInfoDo reqDo, List<SysAuthDistributeSubDo> newDoList) {
        SysRoleInfoDo addReqBo = new SysRoleInfoDo();
        for (SysAuthDistributeSubDo subDo : newDoList) {
            subDo.setAuthId(IdUtil.nextId());
            subDo.setRoleId(reqDo.getRoleId());
            subDo.setDisFlag(AuthDicConstant.ROLE_DIS_FLAG.ORG);
            subDo.setCreateOperId(reqDo.getUpdateOperId());
            subDo.setCreateOperName(reqDo.getUpdateOperName());
            subDo.setCreateTime(reqDo.getUpdateTime());
            subDo.setUpdateOperId(reqDo.getUpdateOperId());
            subDo.setUpdateOperName(reqDo.getUpdateOperName());
            subDo.setUpdateTime(reqDo.getUpdateTime());
        }
        addReqBo.setAuthDistributeList(newDoList);
        this.iSysRoleInfoModel.addAuthDistribute(addReqBo);
    }

    private void deleteRolePower(SysRoleInfoDo reqDo, List<SysAuthDistributeSubDo> oldDoList) {
        SysRoleInfoDo deleteDo = new SysRoleInfoDo();
        for (SysAuthDistributeSubDo subDo : oldDoList) {
            subDo.setRoleId(reqDo.getRoleId());
            subDo.setUpdateOperId(reqDo.getUpdateOperId());
            subDo.setUpdateOperName(reqDo.getCreateOperName());
            subDo.setUpdateTime(reqDo.getCreateTime());
            subDo.setDelFlag("1");
        }
        deleteDo.setAuthDistributeList(oldDoList);
        this.iSysRoleInfoModel.updateAuthDistribute(deleteDo);
    }

    private void validateArg(AuthDealRoleOrgListReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthDealOrgRoleReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getRoleId() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[RoleId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getAuthDistributeList())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[\u65b0\u589e\u5217\u8868\u548c\u5220\u9664\u5217\u8868]\u4e0d\u80fd\u90fd\u4e3a\u7a7a");
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getAuthDistributeList())) {
            for (AuthDistributeBo bo : reqBo.getAuthDistributeList()) {
                if (bo.getOrgTreePath() == null) {
                    throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[OrgTreePath]\u4e0d\u80fd\u90fd\u4e3a\u7a7a");
                }
                if (bo.getOperType() != null) continue;
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[OperType]\u4e0d\u80fd\u90fd\u4e3a\u7a7a");
            }
        }
    }
}

