/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.subpage;

import com.tydic.dyc.authority.model.menu.ISysMenuModel;
import com.tydic.dyc.authority.model.menu.SysMenuDo;
import com.tydic.dyc.authority.model.menu.qrybo.SysMenuQryBo;
import com.tydic.dyc.authority.model.subpage.ISysSubpageModel;
import com.tydic.dyc.authority.model.subpage.SysSubpageDo;
import com.tydic.dyc.authority.model.subpage.qrybo.SysSubpageQryBo;
import com.tydic.dyc.authority.service.subpage.AuthModifySubpageService;
import com.tydic.dyc.authority.service.subpage.bo.AuthModifySubpageReqBo;
import com.tydic.dyc.authority.service.subpage.bo.AuthModifySubpageRspBo;
import com.tydic.dyc.authority.service.subpage.bo.AuthSubpageInfoBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.authority.utils.StrUtil;
import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AUTHORITY_CENTER_DEV/2.0.0/com.tydic.dyc.authority.service.subpage.AuthModifySubpageService"})
public class AuthModifySubpageServiceImpl
implements AuthModifySubpageService {
    @Autowired
    private ISysSubpageModel iSysSubpageModel;
    @Autowired
    private ISysMenuModel iSysMenuModel;

    @PostMapping(value={"modifySubpage"})
    public AuthModifySubpageRspBo modifySubpage(@RequestBody AuthModifySubpageReqBo reqBo) {
        AuthModifySubpageRspBo rspBo = AuthRu.success(AuthModifySubpageRspBo.class);
        this.validateArg(reqBo);
        SysSubpageDo reqDo = this.buildDoByBO(reqBo);
        if (!StringUtils.isBlank((CharSequence)reqBo.getPageCode())) {
            SysMenuQryBo menuQryBo = new SysMenuQryBo();
            menuQryBo.setMenuCode(reqBo.getPageCode());
            List<SysMenuDo> menuList = this.iSysMenuModel.getMenuList(menuQryBo);
            if (!CollectionUtils.isEmpty(menuList)) {
                throw new BaseBusinessException("100001", "\u83dc\u5355\u7f16\u7801\u4e0d\u80fd\u91cd\u590d");
            }
            SysSubpageQryBo pageQryBo = new SysSubpageQryBo();
            pageQryBo.setPageCode(reqBo.getPageCode());
            ArrayList<Long> excludePageIds = new ArrayList<Long>();
            excludePageIds.add(reqBo.getPageId());
            pageQryBo.setExcludePageIds(excludePageIds);
            BasePageRspBo<SysSubpageDo> subpageList = this.iSysSubpageModel.getSubpageList(pageQryBo);
            if (!CollectionUtils.isEmpty((Collection)subpageList.getRows())) {
                throw new BaseBusinessException("100001", "\u5b50\u9875\u9762\u7f16\u7801\u4e0d\u80fd\u91cd\u590d");
            }
        }
        SysSubpageQryBo qryBo = new SysSubpageQryBo();
        qryBo.setPageId(reqBo.getPageId());
        SysSubpageDo detailDo = this.iSysSubpageModel.getSubpageInfoDetails(qryBo);
        if (detailDo == null || detailDo.getPageId() == null) {
            throw new BaseBusinessException("100001", "\u672a\u67e5\u8be2\u5230\u83dc\u5355\u4fe1\u606f");
        }
        qryBo.setPageId(reqBo.getPageId());
        SysSubpageDo rspDo = this.iSysSubpageModel.modifySubpageInfo(reqDo, qryBo);
        AuthSubpageInfoBo menuInfoBo = AuthRu.js(rspDo, AuthSubpageInfoBo.class);
        rspBo.setSubpageInfoBo(menuInfoBo);
        return rspBo;
    }

    private SysSubpageDo buildDoByBO(AuthModifySubpageReqBo reqBo) {
        reqBo.setUpdateTime(new Date());
        SysSubpageDo reqDo = StrUtil.noNullStringAttr(AuthRu.js(reqBo, SysSubpageDo.class));
        return reqDo;
    }

    private void validateArg(AuthModifySubpageReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthCreateMenuReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getPageId() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[MenuId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getPageCode() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[PageCode]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

