/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.subpage;

import com.tydic.dyc.authority.model.subpageRel.ISysSubPageRelModel;
import com.tydic.dyc.authority.model.subpageRel.SysSubPageRelDo;
import com.tydic.dyc.authority.model.subpageRel.qrybo.SysSubpageRelQryBO;
import com.tydic.dyc.authority.service.subpage.AuthSubpageBindMenuService;
import com.tydic.dyc.authority.service.subpage.bo.AuthSubpageBindMenuReqBo;
import com.tydic.dyc.authority.service.subpage.bo.AuthSubpageBindMenuRspBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.authority.utils.IdUtil;
import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AUTHORITY_CENTER_DEV/2.0.0/com.tydic.dyc.authority.service.subpage.AuthSubpageBindMenuService"})
public class AuthSubpageBindMenuServiceImpl
implements AuthSubpageBindMenuService {
    private static final Logger log = LoggerFactory.getLogger(AuthSubpageBindMenuServiceImpl.class);
    @Autowired
    private ISysSubPageRelModel iSysSubPageRelModel;

    @PostMapping(value={"bindMenu"})
    public AuthSubpageBindMenuRspBo bindMenu(@RequestBody AuthSubpageBindMenuReqBo reqBo) {
        this.initCheck(reqBo);
        AuthSubpageBindMenuRspBo rspBo = AuthRu.success(AuthSubpageBindMenuRspBo.class);
        ArrayList<SysSubPageRelDo> sysSubPageRelDos = new ArrayList<SysSubPageRelDo>();
        SysSubpageRelQryBO sysSubpageRelQryBO = new SysSubpageRelQryBO();
        sysSubpageRelQryBO.setPageNo(-1);
        sysSubpageRelQryBO.setPageSize(-1);
        if ("1".equals(reqBo.getOperType())) {
            this.iSysSubPageRelModel.updateByPageId(reqBo.getPageId());
            if (!CollectionUtils.isEmpty((Collection)reqBo.getMenuIds())) {
                for (Long menuId : reqBo.getMenuIds()) {
                    SysSubPageRelDo sysSubPageRelDo = new SysSubPageRelDo();
                    sysSubPageRelDo.setRelId(IdUtil.nextId());
                    sysSubPageRelDo.setPageId(reqBo.getPageId());
                    sysSubPageRelDo.setMenuId(menuId);
                    sysSubPageRelDo.setCreateOperId(reqBo.getCreateOperId());
                    sysSubPageRelDo.setCreateOperName(reqBo.getCreateOperName());
                    sysSubPageRelDo.setDelFlag("0");
                    sysSubPageRelDos.add(sysSubPageRelDo);
                }
            }
        } else if ("2".equals(reqBo.getOperType())) {
            sysSubpageRelQryBO.setMenuId(reqBo.getMenuId());
            BasePageRspBo<SysSubPageRelDo> pageRspBo = this.iSysSubPageRelModel.queryBoundPage(sysSubpageRelQryBO);
            Map<Long, Long> map = pageRspBo.getRows().stream().collect(Collectors.toMap(SysSubPageRelDo::getPageId, SysSubPageRelDo::getMenuId));
            for (Long pageId : reqBo.getPageIds()) {
                if (map.get(pageId) == null) continue;
                SysSubPageRelDo sysSubPageRelDo = new SysSubPageRelDo();
                sysSubPageRelDo.setRelId(IdUtil.nextId());
                sysSubPageRelDo.setPageId(pageId);
                sysSubPageRelDo.setMenuId(reqBo.getMenuId());
                sysSubPageRelDo.setCreateOperId(reqBo.getCreateOperId());
                sysSubPageRelDo.setCreateOperName(reqBo.getCreateOperName());
                sysSubPageRelDo.setDelFlag("0");
                sysSubPageRelDos.add(sysSubPageRelDo);
            }
        }
        if (!CollectionUtils.isEmpty(sysSubPageRelDos)) {
            this.iSysSubPageRelModel.createRelBatch(sysSubPageRelDos);
        }
        return rspBo;
    }

    private void initCheck(AuthSubpageBindMenuReqBo reqBo) {
        if (StringUtils.isBlank((CharSequence)reqBo.getOperType())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ("1".equals(reqBo.getOperType())) {
            if (null == reqBo.getPageId()) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5b50\u9875\u9762id\u4e0d\u80fd\u4e3a\u7a7a");
            }
        } else if ("2".equals(reqBo.getOperType())) {
            if (null == reqBo.getMenuId()) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u83dc\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (CollectionUtils.isEmpty((Collection)reqBo.getPageIds())) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5b50\u9875\u9762id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
            }
        } else {
            throw new BaseBusinessException("100001", "\u672a\u77e5\u7684\u64cd\u4f5c\u7c7b\u578b");
        }
    }
}

