/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.user;

import com.tydic.dyc.authority.constants.AuthDicConstant;
import com.tydic.dyc.authority.model.common.sub.SysAuthDistributeSubDo;
import com.tydic.dyc.authority.model.common.sub.SysRoleInfoSubDo;
import com.tydic.dyc.authority.model.user.ISysUserInfoModel;
import com.tydic.dyc.authority.model.user.SysUserInfoDo;
import com.tydic.dyc.authority.model.user.qrybo.SysCustExtMapQryBo;
import com.tydic.dyc.authority.model.user.qrybo.SysUserInfoQryBo;
import com.tydic.dyc.authority.model.user.qrybo.SysUserTagRelQryBo;
import com.tydic.dyc.authority.model.user.sub.SysCustExtMapSubDo;
import com.tydic.dyc.authority.model.user.sub.SysCustInfoSubDo;
import com.tydic.dyc.authority.model.user.sub.SysUserTagRelSubDo;
import com.tydic.dyc.authority.service.user.AuthModifyUserInfoService;
import com.tydic.dyc.authority.service.user.bo.AuthCustExtMapBo;
import com.tydic.dyc.authority.service.user.bo.AuthModifyUserInfoReqBo;
import com.tydic.dyc.authority.service.user.bo.AuthModifyUserInfoRspBo;
import com.tydic.dyc.authority.service.user.bo.AuthUserInfoBo;
import com.tydic.dyc.authority.service.user.bo.AuthUserTagRelBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.authority.utils.IdUtil;
import com.tydic.dyc.authority.utils.StrUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AUTHORITY_CENTER_DEV/2.0.0/com.tydic.dyc.authority.service.user.AuthModifyUserInfoService"})
public class AuthModifyUserInfoServiceImpl
implements AuthModifyUserInfoService {
    @Autowired
    private ISysUserInfoModel iSysUserInfoModel;

    @PostMapping(value={"AuthModifyUserInfo"})
    public AuthModifyUserInfoRspBo AuthModifyUserInfo(@RequestBody AuthModifyUserInfoReqBo reqBo) {
        AuthModifyUserInfoRspBo rspBo = AuthRu.success(AuthModifyUserInfoRspBo.class);
        this.validateArg(reqBo);
        SysUserInfoQryBo qryBo = new SysUserInfoQryBo();
        qryBo.setUserId(reqBo.getUserId());
        SysUserInfoDo userInfoDo = this.iSysUserInfoModel.getUserInfoDetails(qryBo);
        if (userInfoDo == null || userInfoDo.getUserId() == null) {
            throw new BaseBusinessException("100001", "\u672a\u67e5\u8be2\u5230\u7528\u6237\u4fe1\u606f");
        }
        SysUserInfoDo reqDo = this.buildDoByBO(reqBo);
        if (reqDo.getCustInfo() != null && reqDo.getCustInfo().getCustId() == null) {
            reqDo.getCustInfo().setCustId(userInfoDo.getCustId());
        }
        SysUserInfoDo rspDo = this.iSysUserInfoModel.modifyUserInfo(reqDo, qryBo);
        if (!CollectionUtils.isEmpty(reqDo.getAuthDistributeList())) {
            this.iSysUserInfoModel.addUserRoleList(reqDo);
        }
        if ("1".equals(reqBo.getIsChngTag())) {
            SysUserTagRelQryBo qryTagBo = new SysUserTagRelQryBo();
            qryTagBo.setUserId(reqBo.getUserId());
            List<SysUserTagRelSubDo> oldTagList = this.iSysUserInfoModel.getUserTagList(qryTagBo);
            List<SysUserTagRelSubDo> reqTagList = reqDo.getUserTagRelList();
            ArrayList<SysUserTagRelSubDo> equalsOldSubDo = new ArrayList<SysUserTagRelSubDo>();
            ArrayList<SysUserTagRelSubDo> equalsreqSubDo = new ArrayList<SysUserTagRelSubDo>();
            for (SysUserTagRelSubDo tagRelSubDo : oldTagList) {
                for (SysUserTagRelSubDo sysUserTagRelSubDo : reqDo.getUserTagRelList()) {
                    if (!tagRelSubDo.getTagId().equals(sysUserTagRelSubDo.getTagId())) continue;
                    equalsOldSubDo.add(tagRelSubDo);
                    equalsreqSubDo.add(sysUserTagRelSubDo);
                }
            }
            oldTagList.removeAll(equalsOldSubDo);
            reqTagList.removeAll(equalsreqSubDo);
            this.addUserTag(reqDo, reqTagList);
            this.deleteUserTag(reqDo, oldTagList);
        }
        if ("1".equals(reqBo.getIsChngAuthDistribute())) {
            SysUserInfoQryBo userQryBo = new SysUserInfoQryBo();
            userQryBo.setUserId(reqDo.getUserId());
            SysUserInfoDo userRoleDo = this.iSysUserInfoModel.getRoleInfoListByUser(userQryBo);
            List<SysRoleInfoSubDo> oldRoleList = userRoleDo.getUserRoleList();
            List<SysAuthDistributeSubDo> addSubDo = reqDo.getAuthDistributeList();
            ArrayList<SysAuthDistributeSubDo> eqaulsSubDo = new ArrayList<SysAuthDistributeSubDo>();
            ArrayList<SysRoleInfoSubDo> eqaulsRoleList = new ArrayList<SysRoleInfoSubDo>();
            block2: for (SysRoleInfoSubDo tagRelSubDo : oldRoleList) {
                for (SysAuthDistributeSubDo reqDistributeSubDo : addSubDo) {
                    if (!tagRelSubDo.getRoleId().equals(reqDistributeSubDo.getRoleId())) continue;
                    eqaulsSubDo.add(reqDistributeSubDo);
                    eqaulsRoleList.add(tagRelSubDo);
                    continue block2;
                }
            }
            oldRoleList.removeAll(eqaulsRoleList);
            addSubDo.removeAll(eqaulsSubDo);
            this.addUserRole(reqDo, addSubDo);
            this.deleteUserRole(reqDo, oldRoleList);
        }
        if (!CollectionUtils.isEmpty(reqDo.getCustExtMapList())) {
            SysCustExtMapQryBo extMapQryBo = new SysCustExtMapQryBo();
            extMapQryBo.setCustId(reqDo.getCustId());
            extMapQryBo.setFieldCodes(reqDo.getFieldCodes());
            List<SysCustExtMapSubDo> extMapList = this.iSysUserInfoModel.getCustExtMapList(extMapQryBo);
            ArrayList<SysCustExtMapSubDo> updateList = new ArrayList<SysCustExtMapSubDo>();
            List<SysCustExtMapSubDo> addList = reqDo.getCustExtMapList();
            block4: for (SysCustExtMapSubDo newCustExtMap : reqDo.getCustExtMapList()) {
                for (SysCustExtMapSubDo oldCustExtMap : extMapList) {
                    if (!oldCustExtMap.getFieldCode().equals(newCustExtMap.getFieldCode())) continue;
                    SysCustExtMapSubDo sysCustExtMapSubDo = AuthRu.js(newCustExtMap, SysCustExtMapSubDo.class);
                    updateList.add(sysCustExtMapSubDo);
                    continue block4;
                }
            }
            addList.removeAll(updateList);
            this.addCustExtMap(reqDo, addList);
            this.updateCustExtMap(reqDo, updateList);
        }
        AuthUserInfoBo DoToBo = AuthRu.js(rspDo, AuthUserInfoBo.class);
        rspBo.setUserInfoBo(DoToBo);
        return rspBo;
    }

    private SysUserInfoDo buildDoByBO(AuthModifyUserInfoReqBo reqBo) {
        Serializable subDo;
        reqBo.setUpdateTime(new Date());
        SysUserInfoDo reqDo = StrUtil.noNullStringAttr(AuthRu.js(reqBo, SysUserInfoDo.class));
        if (reqBo.getCustInfo() != null && reqBo.getCustId() == null) {
            SysCustInfoSubDo custSubDo = StrUtil.noNullStringAttr(AuthRu.js(reqBo.getCustInfo(), SysCustInfoSubDo.class));
            custSubDo.setUpdateOperId(reqDo.getUpdateOperId());
            custSubDo.setUpdateOperName(reqDo.getUpdateOperName());
            custSubDo.setUpdateTime(reqDo.getUpdateTime());
            reqDo.setCustInfo(custSubDo);
            if (reqBo.getCustInfo().getClearInitialPassword() == 1 && reqBo.getCustInfo().getCustId() != null) {
                this.iSysUserInfoModel.updateCustInfoClearInitialPassword(custSubDo);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getCustExtMapList())) {
            ArrayList<SysCustExtMapSubDo> custExtMapList = new ArrayList<SysCustExtMapSubDo>();
            ArrayList<String> fieldCodes = new ArrayList<String>();
            for (AuthCustExtMapBo bo : reqBo.getCustExtMapList()) {
                SysCustExtMapSubDo subDo2 = AuthRu.js(bo, SysCustExtMapSubDo.class);
                subDo2.setCustId(reqDo.getCustId());
                subDo2.setUpdateOperId(reqDo.getUpdateOperId());
                subDo2.setUpdateOperName(reqDo.getUpdateOperName());
                subDo2.setUpdateTime(reqDo.getUpdateTime());
                fieldCodes.add(bo.getFieldCode());
                custExtMapList.add(subDo2);
            }
            reqDo.setCustExtMapList(custExtMapList);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getUserTagRelList())) {
            ArrayList<SysUserTagRelSubDo> sysUserTagRelList = new ArrayList<SysUserTagRelSubDo>();
            for (AuthUserTagRelBo bo : reqBo.getUserTagRelList()) {
                subDo = AuthRu.js(bo, SysUserTagRelSubDo.class);
                ((SysUserTagRelSubDo)subDo).setUpdateOperId(reqDo.getUpdateOperId());
                ((SysUserTagRelSubDo)subDo).setUpdateOperName(reqDo.getUpdateOperName());
                ((SysUserTagRelSubDo)subDo).setUpdateTime(reqDo.getUpdateTime());
                sysUserTagRelList.add((SysUserTagRelSubDo)subDo);
            }
            reqDo.setUserTagRelList(sysUserTagRelList);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getAuthDistributeList())) {
            ArrayList<SysAuthDistributeSubDo> authDistributeList = new ArrayList<SysAuthDistributeSubDo>();
            for (AuthUserTagRelBo bo : reqBo.getAuthDistributeList()) {
                subDo = AuthRu.js(bo, SysAuthDistributeSubDo.class);
                ((SysAuthDistributeSubDo)subDo).setUpdateOperId(reqDo.getUpdateOperId());
                ((SysAuthDistributeSubDo)subDo).setUpdateOperName(reqDo.getUpdateOperName());
                ((SysAuthDistributeSubDo)subDo).setUpdateTime(reqDo.getUpdateTime());
                authDistributeList.add((SysAuthDistributeSubDo)subDo);
            }
            reqDo.setAuthDistributeList(authDistributeList);
        }
        return reqDo;
    }

    private void validateArg(AuthModifyUserInfoReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthCreateRoleInfoReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getCustInfo() == null && reqBo.getCustId() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[CustInfoBo\u548cCustId ]\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getCustExtMapList())) {
            for (AuthCustExtMapBo bo : reqBo.getCustExtMapList()) {
                if (bo.getFieldCode() != null) continue;
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[FieldCode]\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getAuthDistributeList())) {
            for (AuthCustExtMapBo bo : reqBo.getAuthDistributeList()) {
                if (bo.getRoleId() != null) continue;
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[RoleId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getUserTagRelList())) {
            for (AuthCustExtMapBo bo : reqBo.getUserTagRelList()) {
                if (bo.getTagId() != null) continue;
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[TagId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }

    private void addUserTag(SysUserInfoDo reqDo, List<SysUserTagRelSubDo> addTagList) {
        SysUserInfoDo addReqBo = new SysUserInfoDo();
        for (SysUserTagRelSubDo subDo : addTagList) {
            subDo.setRelId(IdUtil.nextId());
            subDo.setUserId(reqDo.getUserId());
            subDo.setDelFlag("0");
            subDo.setCreateOperId(reqDo.getUpdateOperId());
            subDo.setCreateOperName(reqDo.getCreateOperName());
            subDo.setCreateTime(reqDo.getUpdateTime());
            subDo.setUpdateOperId(reqDo.getUpdateOperId());
            subDo.setUpdateOperName(reqDo.getCreateOperName());
            subDo.setUpdateTime(reqDo.getUpdateTime());
        }
        addReqBo.setUserTagRelList(addTagList);
        this.iSysUserInfoModel.addUserTagList(addReqBo);
    }

    private void deleteUserTag(SysUserInfoDo reqDo, List<SysUserTagRelSubDo> deleteTagList) {
        SysUserInfoDo addReqBo = new SysUserInfoDo();
        for (SysUserTagRelSubDo subDo : deleteTagList) {
            subDo.setUpdateOperId(reqDo.getUpdateOperId());
            subDo.setUpdateOperName(reqDo.getCreateOperName());
            subDo.setUpdateTime(reqDo.getCreateTime());
            subDo.setDelFlag("1");
        }
        addReqBo.setUserTagRelList(deleteTagList);
        this.iSysUserInfoModel.updateUserTagList(addReqBo);
    }

    private void addUserRole(SysUserInfoDo reqDo, List<SysAuthDistributeSubDo> addRoleList) {
        SysUserInfoDo addReqBo = new SysUserInfoDo();
        for (SysAuthDistributeSubDo subDo : addRoleList) {
            subDo.setAuthId(IdUtil.nextId());
            subDo.setTenantId(reqDo.getTenantId());
            subDo.setUserId(reqDo.getUserId());
            subDo.setDisFlag(AuthDicConstant.ROLE_DIS_FLAG.USER);
            subDo.setCreateOperId(reqDo.getUpdateOperId());
            subDo.setCreateOperName(reqDo.getUpdateOperName());
            subDo.setCreateTime(reqDo.getUpdateTime());
            subDo.setUpdateOperId(reqDo.getUpdateOperId());
            subDo.setUpdateOperName(reqDo.getUpdateOperName());
            subDo.setUpdateTime(reqDo.getUpdateTime());
        }
        addReqBo.setAuthDistributeList(addRoleList);
        this.iSysUserInfoModel.addUserRoleList(addReqBo);
    }

    private void deleteUserRole(SysUserInfoDo reqDo, List<SysRoleInfoSubDo> deleteRoleList) {
        SysUserInfoDo addReqBo = new SysUserInfoDo();
        ArrayList<SysAuthDistributeSubDo> delRoleList = new ArrayList<SysAuthDistributeSubDo>();
        for (SysRoleInfoSubDo roleSubDo : deleteRoleList) {
            SysAuthDistributeSubDo subDo = new SysAuthDistributeSubDo();
            subDo.setRoleId(roleSubDo.getRoleId());
            subDo.setUserId(reqDo.getUserId());
            subDo.setUpdateOperId(reqDo.getUpdateOperId());
            subDo.setUpdateOperName(reqDo.getCreateOperName());
            subDo.setUpdateTime(reqDo.getCreateTime());
            subDo.setDelFlag("1");
            delRoleList.add(subDo);
        }
        addReqBo.setAuthDistributeList(delRoleList);
        this.iSysUserInfoModel.updateUserTagList(addReqBo);
    }

    private void addCustExtMap(SysUserInfoDo reqDo, List<SysCustExtMapSubDo> addCustExtMapList) {
        SysUserInfoDo addReqBo = new SysUserInfoDo();
        for (SysCustExtMapSubDo subDo : addCustExtMapList) {
            subDo.setExtId(IdUtil.nextId());
            subDo.setTenantId(reqDo.getTenantId());
            subDo.setCustId(reqDo.getUserId());
            subDo.setCreateOperId(reqDo.getUpdateOperId());
            subDo.setCreateOperName(reqDo.getUpdateOperName());
            subDo.setCreateTime(reqDo.getUpdateTime());
            subDo.setUpdateOperId(reqDo.getUpdateOperId());
            subDo.setUpdateOperName(reqDo.getUpdateOperName());
            subDo.setUpdateTime(reqDo.getUpdateTime());
        }
        addReqBo.setCustExtMapList(addCustExtMapList);
        this.iSysUserInfoModel.addCustExtMapList(addReqBo);
    }

    private void updateCustExtMap(SysUserInfoDo reqDo, List<SysCustExtMapSubDo> updateCustExtMapList) {
        SysUserInfoDo addReqBo = new SysUserInfoDo();
        for (SysCustExtMapSubDo extMapSubDo : updateCustExtMapList) {
            extMapSubDo.setUpdateOperId(reqDo.getUpdateOperId());
            extMapSubDo.setUpdateOperName(reqDo.getCreateOperName());
            extMapSubDo.setUpdateTime(reqDo.getCreateTime());
        }
        addReqBo.setCustExtMapList(updateCustExtMapList);
        this.iSysUserInfoModel.updateCustExtMapList(addReqBo);
    }
}

