/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.user;

import com.tydic.dyc.authority.constants.AuthConstant;
import com.tydic.dyc.authority.constants.AuthDicConstant;
import com.tydic.dyc.authority.model.common.sub.SysAuthDistributeSubDo;
import com.tydic.dyc.authority.model.user.ISysUserInfoModel;
import com.tydic.dyc.authority.model.user.SysUserInfoDo;
import com.tydic.dyc.authority.model.user.sub.SysCustExtMapSubDo;
import com.tydic.dyc.authority.model.user.sub.SysCustInfoSubDo;
import com.tydic.dyc.authority.model.user.sub.SysUserTagRelSubDo;
import com.tydic.dyc.authority.service.domainservice.bo.AuthDistributeBo;
import com.tydic.dyc.authority.service.user.AuthCreateUserInfoService;
import com.tydic.dyc.authority.service.user.bo.AuthCreateUserInfoReqBo;
import com.tydic.dyc.authority.service.user.bo.AuthCreateUserInfoRspBo;
import com.tydic.dyc.authority.service.user.bo.AuthCustExtMapBo;
import com.tydic.dyc.authority.service.user.bo.AuthUserInfoBo;
import com.tydic.dyc.authority.service.user.bo.AuthUserTagRelBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.authority.utils.IdUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AUTHORITY_CENTER_DEV/2.0.0/com.tydic.dyc.authority.service.user.AuthCreateUserInfoService"})
public class AuthCreateUserInfoServiceImpl
implements AuthCreateUserInfoService {
    @Autowired
    private ISysUserInfoModel iSysUserInfoModel;

    @PostMapping(value={"createUserInfo"})
    public AuthCreateUserInfoRspBo createUserInfo(@RequestBody AuthCreateUserInfoReqBo reqBo) {
        AuthCreateUserInfoRspBo rspBo = AuthRu.success(AuthCreateUserInfoRspBo.class);
        this.validateArg(reqBo);
        SysUserInfoDo reqDo = this.buildDoByBO(reqBo);
        SysUserInfoDo rspDo = this.iSysUserInfoModel.createUserInfo(reqDo);
        if (!CollectionUtils.isEmpty(reqDo.getAuthDistributeList())) {
            this.iSysUserInfoModel.addUserRoleList(reqDo);
        }
        AuthUserInfoBo DoToBo = AuthRu.js(rspDo, AuthUserInfoBo.class);
        rspBo.setUserInfoBo(DoToBo);
        return rspBo;
    }

    private SysUserInfoDo buildDoByBO(AuthCreateUserInfoReqBo reqBo) {
        Serializable subDo;
        reqBo.setCreateTime(new Date());
        reqBo.setUpdateTime(reqBo.getCreateTime());
        SysUserInfoDo reqDo = AuthRu.js(reqBo, SysUserInfoDo.class);
        reqDo.setDelFlag("0");
        if (reqBo.getCustInfo() != null && reqBo.getCustId() == null) {
            SysCustInfoSubDo custSubDo = AuthRu.js(reqBo.getCustInfo(), SysCustInfoSubDo.class);
            reqDo.setCustId(IdUtil.nextId());
            reqDo.setMainCustId(reqDo.getCustId());
            custSubDo.setCustId(reqDo.getCustId());
            custSubDo.setDelFlag("0");
            custSubDo.setCreateOperId(reqDo.getCreateOperId());
            custSubDo.setCreateOperName(reqDo.getCreateOperName());
            custSubDo.setCreateTime(reqDo.getCreateTime());
            custSubDo.setUpdateOperId(reqDo.getUpdateOperId());
            custSubDo.setUpdateOperName(reqDo.getCreateOperName());
            custSubDo.setUpdateTime(reqDo.getCreateTime());
            reqDo.setCustInfo(custSubDo);
            if (!CollectionUtils.isEmpty((Collection)reqBo.getCustExtMapList())) {
                ArrayList<SysCustExtMapSubDo> sysCustExtMapList = new ArrayList<SysCustExtMapSubDo>();
                for (AuthCustExtMapBo custBo : reqBo.getCustExtMapList()) {
                    SysCustExtMapSubDo extSubDo = AuthRu.js(custBo, SysCustExtMapSubDo.class);
                    extSubDo.setCustId(reqDo.getCustId());
                    extSubDo.setCreateOperId(reqDo.getCreateOperId());
                    extSubDo.setCreateOperName(reqDo.getCreateOperName());
                    extSubDo.setCreateTime(reqDo.getCreateTime());
                    extSubDo.setUpdateOperId(reqDo.getUpdateOperId());
                    extSubDo.setUpdateOperName(reqDo.getCreateOperName());
                    extSubDo.setUpdateTime(reqDo.getCreateTime());
                    sysCustExtMapList.add(extSubDo);
                }
                reqDo.setCustExtMapList(sysCustExtMapList);
            }
        }
        reqDo.setUserId(IdUtil.nextId());
        if (!CollectionUtils.isEmpty((Collection)reqBo.getUserTagRelList())) {
            ArrayList<SysUserTagRelSubDo> sysUserTagRelList = new ArrayList<SysUserTagRelSubDo>();
            for (AuthUserTagRelBo bo : reqBo.getUserTagRelList()) {
                subDo = AuthRu.js(bo, SysUserTagRelSubDo.class);
                ((SysUserTagRelSubDo)subDo).setRelId(IdUtil.nextId());
                ((SysUserTagRelSubDo)subDo).setUserId(reqDo.getUserId());
                ((SysUserTagRelSubDo)subDo).setDelFlag("0");
                ((SysUserTagRelSubDo)subDo).setCreateOperId(reqDo.getCreateOperId());
                ((SysUserTagRelSubDo)subDo).setCreateOperName(reqDo.getCreateOperName());
                ((SysUserTagRelSubDo)subDo).setCreateTime(reqDo.getCreateTime());
                ((SysUserTagRelSubDo)subDo).setUpdateOperId(reqDo.getUpdateOperId());
                ((SysUserTagRelSubDo)subDo).setUpdateOperName(reqDo.getCreateOperName());
                ((SysUserTagRelSubDo)subDo).setUpdateTime(reqDo.getCreateTime());
                sysUserTagRelList.add((SysUserTagRelSubDo)subDo);
            }
            reqDo.setUserTagRelList(sysUserTagRelList);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getAuthDistributeList())) {
            ArrayList<SysAuthDistributeSubDo> authDistributeList = new ArrayList<SysAuthDistributeSubDo>();
            for (AuthUserTagRelBo bo : reqBo.getAuthDistributeList()) {
                subDo = AuthRu.js(bo, SysAuthDistributeSubDo.class);
                ((SysAuthDistributeSubDo)subDo).setAuthId(IdUtil.nextId());
                ((SysAuthDistributeSubDo)subDo).setDisFlag(AuthConstant.ROLE_DIS_FLAG.USER);
                ((SysAuthDistributeSubDo)subDo).setDisAgFlag(AuthDicConstant.DIS_AG_FLAG.ALL_AUTHORITY);
                ((SysAuthDistributeSubDo)subDo).setUserId(reqDo.getUserId());
                ((SysAuthDistributeSubDo)subDo).setDelFlag("0");
                ((SysAuthDistributeSubDo)subDo).setCreateOperId(reqDo.getCreateOperId());
                ((SysAuthDistributeSubDo)subDo).setCreateOperName(reqDo.getCreateOperName());
                ((SysAuthDistributeSubDo)subDo).setCreateTime(reqDo.getCreateTime());
                ((SysAuthDistributeSubDo)subDo).setUpdateOperId(reqDo.getUpdateOperId());
                ((SysAuthDistributeSubDo)subDo).setUpdateOperName(reqDo.getCreateOperName());
                ((SysAuthDistributeSubDo)subDo).setUpdateTime(reqDo.getCreateTime());
                authDistributeList.add((SysAuthDistributeSubDo)subDo);
            }
            reqDo.setAuthDistributeList(authDistributeList);
        }
        return reqDo;
    }

    private void validateArg(AuthCreateUserInfoReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthCreateRoleInfoReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getCustInfo() == null && reqBo.getCustId() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[CustInfoBo\u548cCustId ]\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getAuthDistributeList())) {
            for (AuthDistributeBo bo : reqBo.getAuthDistributeList()) {
                if (bo.getRoleId() != null) continue;
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[RoleId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getUserTagRelList())) {
            for (AuthDistributeBo bo : reqBo.getUserTagRelList()) {
                if (bo.getTagId() != null) continue;
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[TagId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }
}

