/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.organization;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.authority.model.organization.ISysOrgInfoModel;
import com.tydic.dyc.authority.model.organization.SysOrgInfoDo;
import com.tydic.dyc.authority.model.organization.qrybo.SysOrgInfoQryBo;
import com.tydic.dyc.authority.model.organization.qrybo.SysOrgTagRelQryBo;
import com.tydic.dyc.authority.model.organization.sub.SysOrgTagRelSubDo;
import com.tydic.dyc.authority.service.organization.AuthGetOrgInfoDetailService;
import com.tydic.dyc.authority.service.organization.bo.AuthGetOrgInfoDetailReqBo;
import com.tydic.dyc.authority.service.organization.bo.AuthGetOrgInfoDetailRspBo;
import com.tydic.dyc.authority.service.organization.bo.AuthOrgInfoBo;
import com.tydic.dyc.authority.service.organization.bo.AuthOrgTagRelBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AUTHORITY_CENTER_DEV/2.0.0/com.tydic.dyc.authority.service.organization.AuthGetOrgInfoDetailService"})
public class AuthGetOrgInfoDetailServiceImpl
implements AuthGetOrgInfoDetailService {
    private static final Logger log = LoggerFactory.getLogger(AuthGetOrgInfoDetailServiceImpl.class);
    @Autowired
    private ISysOrgInfoModel iSysOrgInfoModel;

    @PostMapping(value={"getOrgInfoDetail"})
    public AuthGetOrgInfoDetailRspBo getOrgInfoDetail(@RequestBody AuthGetOrgInfoDetailReqBo reqBo) {
        AuthGetOrgInfoDetailRspBo rspBo = AuthRu.success(AuthGetOrgInfoDetailRspBo.class);
        this.validateArg(reqBo);
        SysOrgInfoQryBo qryBo = new SysOrgInfoQryBo();
        qryBo.setOrgId(reqBo.getOrgId());
        SysOrgInfoDo rspDo = this.iSysOrgInfoModel.getOrgInfoDetails(qryBo);
        log.debug("\u673a\u6784\u8be6\u60c5\u51fa\u53c2{}", (Object)JSON.toJSONString((Object)rspDo));
        if (rspDo == null || rspDo.getOrgId() == null) {
            throw new BaseBusinessException("100001", "\u672a\u67e5\u8be2\u5230\u673a\u6784\u4fe1\u606f");
        }
        AuthOrgInfoBo DoToBo = AuthRu.js(rspDo, AuthOrgInfoBo.class);
        SysOrgTagRelQryBo tagQryBo = new SysOrgTagRelQryBo();
        tagQryBo.setOrgId(rspDo.getOrgId());
        List<SysOrgTagRelSubDo> orgTagDoList = this.iSysOrgInfoModel.getOrgTagList(tagQryBo);
        List<AuthOrgTagRelBo> orgTagBoList = AuthRu.jsl(orgTagDoList, AuthOrgTagRelBo.class);
        DoToBo.setOrgTagList(orgTagBoList);
        rspBo.setOrgInfoBo(DoToBo);
        log.debug("\u673a\u6784\u8be6\u60c5\u51fa\u53c2{}", (Object)JSON.toJSONString((Object)rspBo));
        return rspBo;
    }

    private void validateArg(AuthGetOrgInfoDetailReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthGetOrgInfoDetailReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getOrgId() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[orgId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

