/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.orgtype;

import com.tydic.dyc.authority.model.orgtype.ISysOrgTypeModel;
import com.tydic.dyc.authority.model.orgtype.SysOrgTypeDo;
import com.tydic.dyc.authority.model.orgtype.qrybo.SysOrgTypeQryBo;
import com.tydic.dyc.authority.model.orgtype.sub.SysOrgTypeRelSubDo;
import com.tydic.dyc.authority.service.orgtype.AuthDealSubOrgTypeService;
import com.tydic.dyc.authority.service.orgtype.bo.AuthDealSubOrgTypeReqBo;
import com.tydic.dyc.authority.service.orgtype.bo.AuthDealSubOrgTypeRspBo;
import com.tydic.dyc.authority.service.orgtype.bo.AuthOrgTypeRelBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.authority.utils.IdUtil;
import com.tydic.dyc.authority.utils.StrUtil;
import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AUTHORITY_CENTER_DEV/2.0.0/com.tydic.dyc.authority.service.orgtype.AuthDealSubOrgTypeService"})
public class AuthDealSubOrgTypeServiceImpl
implements AuthDealSubOrgTypeService {
    @Autowired
    private ISysOrgTypeModel iSysOrgTypeModel;

    @PostMapping(value={"dealSubOrgType"})
    public AuthDealSubOrgTypeRspBo dealSubOrgType(@RequestBody AuthDealSubOrgTypeReqBo reqBo) {
        AuthDealSubOrgTypeRspBo rspBo = AuthRu.success(AuthDealSubOrgTypeRspBo.class);
        this.validateArg(reqBo);
        SysOrgTypeDo orgTypeDo = AuthRu.js(reqBo, SysOrgTypeDo.class);
        if (reqBo.getOrgTypeId() != null) {
            SysOrgTypeQryBo qryBo = new SysOrgTypeQryBo();
            qryBo.setOrgTypeId(reqBo.getOrgTypeId());
            BasePageRspBo<SysOrgTypeDo> rspDetailDo = this.iSysOrgTypeModel.getOrgTypePageList(qryBo);
            if (rspDetailDo == null || CollectionUtils.isEmpty((Collection)rspDetailDo.getRows())) {
                throw new BaseBusinessException("100001", "\u672a\u67e5\u8be2\u5230\u673a\u6784\u7c7b\u578b\u4fe1\u606f");
            }
            orgTypeDo.setUpdateTime(new Date());
            StrUtil.noNullStringAttr(orgTypeDo);
            this.iSysOrgTypeModel.modifyOrgTypeInfo(orgTypeDo);
        } else {
            orgTypeDo.setOrgTypeId(IdUtil.nextId());
            orgTypeDo.setCreateOperId(orgTypeDo.getUpdateOperId());
            orgTypeDo.setCreateOperName(orgTypeDo.getCreateOperName());
            orgTypeDo.setUpdateTime(new Date());
            orgTypeDo.setCreateTime(orgTypeDo.getUpdateTime());
            orgTypeDo.setIsCustom("1");
            StrUtil.noNullStringAttr(orgTypeDo);
            this.iSysOrgTypeModel.createOrgTypeInfo(orgTypeDo);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getOrgTypeRelList())) {
            SysOrgTypeDo reqDo = this.buildDoByBO(reqBo);
            SysOrgTypeQryBo qryTagBo = new SysOrgTypeQryBo();
            qryTagBo.setParentTypeId(orgTypeDo.getOrgTypeId());
            qryTagBo.setReturnAll(false);
            List<SysOrgTypeDo> oldSubTypeList = this.iSysOrgTypeModel.getSubOrgTypeList(qryTagBo);
            List<SysOrgTypeRelSubDo> reqOrgTypeList = reqDo.getOrgTypeRelList();
            ArrayList<SysOrgTypeDo> equalsOldSubDo = new ArrayList<SysOrgTypeDo>();
            ArrayList<SysOrgTypeRelSubDo> equalsreqSubDo = new ArrayList<SysOrgTypeRelSubDo>();
            block0: for (SysOrgTypeDo oldSubDo : oldSubTypeList) {
                for (SysOrgTypeRelSubDo reqSubDo : reqDo.getOrgTypeRelList()) {
                    if (!reqSubDo.getOrgTypeId().equals(oldSubDo.getOrgTypeId())) continue;
                    equalsOldSubDo.add(oldSubDo);
                    equalsreqSubDo.add(reqSubDo);
                    continue block0;
                }
            }
            oldSubTypeList.removeAll(equalsOldSubDo);
            reqOrgTypeList.removeAll(equalsreqSubDo);
            if (!CollectionUtils.isEmpty(reqOrgTypeList)) {
                this.addOrgType(orgTypeDo, reqOrgTypeList);
            }
            if (!CollectionUtils.isEmpty(oldSubTypeList)) {
                this.deleteOrgType(orgTypeDo, oldSubTypeList);
            }
        }
        return rspBo;
    }

    private SysOrgTypeDo buildDoByBO(AuthDealSubOrgTypeReqBo reqBo) {
        reqBo.setUpdateTime(new Date());
        SysOrgTypeDo reqDo = AuthRu.js(reqBo, SysOrgTypeDo.class);
        if (!CollectionUtils.isEmpty((Collection)reqBo.getOrgTypeRelList())) {
            ArrayList<SysOrgTypeRelSubDo> ortTypeRelList = new ArrayList<SysOrgTypeRelSubDo>();
            for (AuthOrgTypeRelBo bo : reqBo.getOrgTypeRelList()) {
                SysOrgTypeRelSubDo subDo = AuthRu.js(bo, SysOrgTypeRelSubDo.class);
                subDo.setUpdateOperId(reqDo.getUpdateOperId());
                subDo.setUpdateOperName(reqDo.getUpdateOperName());
                subDo.setUpdateTime(reqDo.getUpdateTime());
                ortTypeRelList.add(subDo);
            }
            reqDo.setOrgTypeRelList(ortTypeRelList);
        }
        return reqDo;
    }

    private void validateArg(AuthDealSubOrgTypeReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthDealOrgRoleReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getOrgTypeRelList())) {
            for (AuthOrgTypeRelBo bo : reqBo.getOrgTypeRelList()) {
                if (bo.getOrgTypeId() != null) continue;
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[OrgTypeId]\u4e0d\u80fd\u90fd\u4e3a\u7a7a");
            }
        }
    }

    private void addOrgType(SysOrgTypeDo reqDo, List<SysOrgTypeRelSubDo> addOrgTypeList) {
        SysOrgTypeDo addReqBo = new SysOrgTypeDo();
        for (SysOrgTypeRelSubDo subDo : addOrgTypeList) {
            subDo.setRelId(IdUtil.nextId());
            subDo.setOrgTypeId(subDo.getOrgTypeId());
            subDo.setParentTypeId(reqDo.getOrgTypeId());
            subDo.setCreateOperId(reqDo.getUpdateOperId());
            subDo.setCreateOperName(reqDo.getUpdateOperName());
            subDo.setCreateTime(reqDo.getUpdateTime());
            subDo.setUpdateOperId(reqDo.getUpdateOperId());
            subDo.setUpdateOperName(reqDo.getUpdateOperName());
            subDo.setUpdateTime(reqDo.getUpdateTime());
        }
        addReqBo.setOrgTypeRelList(addOrgTypeList);
        StrUtil.noNullStringAttr(addReqBo);
        this.iSysOrgTypeModel.addSubOrgTypeRel(addReqBo);
    }

    private void deleteOrgType(SysOrgTypeDo reqDo, List<SysOrgTypeDo> deleteOrgTypeList) {
        SysOrgTypeDo addReqBo = new SysOrgTypeDo();
        ArrayList<SysOrgTypeRelSubDo> delOrgTypeList = new ArrayList<SysOrgTypeRelSubDo>();
        for (SysOrgTypeDo orgTypeSubDo : deleteOrgTypeList) {
            SysOrgTypeRelSubDo subDo = new SysOrgTypeRelSubDo();
            subDo.setOrgTypeId(orgTypeSubDo.getOrgTypeId());
            subDo.setParentTypeId(reqDo.getOrgTypeId());
            subDo.setUpdateOperId(reqDo.getUpdateOperId());
            subDo.setUpdateOperName(reqDo.getUpdateOperName());
            subDo.setUpdateTime(reqDo.getUpdateTime());
            subDo.setDelFlag("1");
            delOrgTypeList.add(subDo);
        }
        addReqBo.setOrgTypeRelList(delOrgTypeList);
        StrUtil.noNullStringAttr(addReqBo);
        this.iSysOrgTypeModel.updateSubOrgTypeRel(addReqBo);
    }
}

