/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.role;

import com.tydic.dyc.authority.model.organization.ISysOrgInfoModel;
import com.tydic.dyc.authority.model.organization.SysOrgInfoDo;
import com.tydic.dyc.authority.model.organization.qrybo.SysOrgInfoQryBo;
import com.tydic.dyc.authority.service.role.AuthDataPowerOrgTreeEchoService;
import com.tydic.dyc.authority.service.role.bo.AuthDataPowerOrgTreeEchoReqBo;
import com.tydic.dyc.authority.service.role.bo.AuthDataPowerOrgTreeEchoRspBo;
import com.tydic.dyc.authority.service.role.bo.AuthOtherOrgBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AUTHORITY_CENTER_DEV/2.0.0/com.tydic.dyc.authority.service.role.AuthDataPowerOrgTreeEchoService"})
public class AuthDataPowerOrgTreeEchoServiceImpl
implements AuthDataPowerOrgTreeEchoService {
    @Autowired
    private ISysOrgInfoModel iSysOrgInfoModel;

    @PostMapping(value={"getDataPowerOrgTreeEcho"})
    public AuthDataPowerOrgTreeEchoRspBo getDataPowerOrgTreeEcho(@RequestBody AuthDataPowerOrgTreeEchoReqBo reqBo) {
        AuthDataPowerOrgTreeEchoRspBo rspBo = AuthRu.success(AuthDataPowerOrgTreeEchoRspBo.class);
        this.validateArg(reqBo);
        ArrayList<AuthOtherOrgBo> authOtherOrgBoList = new ArrayList<AuthOtherOrgBo>();
        for (Long orgId : reqBo.getOrgIdList()) {
            SysOrgInfoQryBo orgQryBo = new SysOrgInfoQryBo();
            orgQryBo.setOrgId(orgId);
            SysOrgInfoDo details = this.iSysOrgInfoModel.getOrgInfoDetails(orgQryBo);
            AuthOtherOrgBo authOtherOrgBo = new AuthOtherOrgBo();
            authOtherOrgBo.setOrgId(details.getOrgId());
            authOtherOrgBo.setOrgName(details.getOrgName());
            authOtherOrgBo.setHasSel(true);
            authOtherOrgBo.setParentId(details.getParentId());
            authOtherOrgBoList.add(authOtherOrgBo);
        }
        List<AuthOtherOrgBo> tree = this.createTree(authOtherOrgBoList, null);
        rspBo.setRows(tree);
        return rspBo;
    }

    private void validateArg(AuthDataPowerOrgTreeEchoReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthDataPowerOrgTreeEchoReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getOrgIdList() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[orgIdList]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private List<AuthOtherOrgBo> createTree(List<AuthOtherOrgBo> lists, Long pid) {
        ArrayList<AuthOtherOrgBo> tree = new ArrayList<AuthOtherOrgBo>();
        for (AuthOtherOrgBo authOtherOrgBo : lists) {
            if (!authOtherOrgBo.getParentId().equals(pid)) continue;
            authOtherOrgBo.setChildOrg(this.createTree(lists, authOtherOrgBo.getOrgId()));
            tree.add(authOtherOrgBo);
        }
        return tree;
    }
}

