/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.role;

import com.tydic.dyc.authority.model.menu.ISysMenuModel;
import com.tydic.dyc.authority.model.menu.SysMenuDo;
import com.tydic.dyc.authority.model.menu.qrybo.SysMenuQryBo;
import com.tydic.dyc.authority.model.role.ISysRoleInfoModel;
import com.tydic.dyc.authority.model.role.SysRoleInfoDo;
import com.tydic.dyc.authority.model.role.qrybo.SysRoleInfoQryBo;
import com.tydic.dyc.authority.model.role.sub.SysMenuSubDo;
import com.tydic.dyc.authority.service.role.AuthRoleMenuSecondaryTreeQryService;
import com.tydic.dyc.authority.service.role.bo.AuthRoleMenuSecondaryTreeBo;
import com.tydic.dyc.authority.service.role.bo.AuthRoleMenuSecondaryTreeQryReqBo;
import com.tydic.dyc.authority.service.role.bo.AuthRoleMenuSecondaryTreeQryRspBo;
import com.tydic.dyc.authority.utils.AuthRu;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AUTHORITY_CENTER_DEV/2.0.0/com.tydic.dyc.authority.service.role.AuthRoleMenuSecondaryTreeQryService"})
public class AuthRoleMenuSecondaryTreeQryServiceImpl
implements AuthRoleMenuSecondaryTreeQryService {
    @Autowired
    private ISysRoleInfoModel iSysRoleInfoModel;
    @Autowired
    private ISysMenuModel iSysMenuModel;
    private static final Integer A = 1;
    private static final String QRYTYPE = "2";
    private static final Integer B = 2;

    @PostMapping(value={"getRoleMenuSecondaryTree"})
    public AuthRoleMenuSecondaryTreeQryRspBo getRoleMenuSecondaryTree(@RequestBody AuthRoleMenuSecondaryTreeQryReqBo reqBo) {
        AuthRoleMenuSecondaryTreeQryRspBo rspBo = new AuthRoleMenuSecondaryTreeQryRspBo();
        SysRoleInfoQryBo qryBo = new SysRoleInfoQryBo();
        qryBo.setRoleId(reqBo.getRoleId());
        SysRoleInfoDo rspDo = this.iSysRoleInfoModel.getRoleMenuRelList(qryBo);
        List<SysMenuSubDo> sysMenuSubDos = rspDo.getMenuList();
        List<SysMenuDo> menuListRle = AuthRu.jsl(sysMenuSubDos, SysMenuDo.class);
        List<AuthRoleMenuSecondaryTreeBo> relTreeBo = this.build(menuListRle);
        if (QRYTYPE.equals(reqBo.getQryType())) {
            SysMenuQryBo sysMenuQryBo = new SysMenuQryBo();
            List menuListAll = this.iSysMenuModel.getMenuList(sysMenuQryBo).getRows();
            List<AuthRoleMenuSecondaryTreeBo> allTreeBo = this.build(menuListAll);
            this.hasSel(allTreeBo, relTreeBo);
            this.buildByRecursive(allTreeBo);
            rspBo.setRows(allTreeBo);
        } else {
            if (relTreeBo.size() > 0) {
                this.buildByRecursive(relTreeBo);
            }
            for (AuthRoleMenuSecondaryTreeBo bo : relTreeBo) {
                bo.setHasSel(true);
            }
            rspBo.setRows(relTreeBo);
        }
        return rspBo;
    }

    private void find(List<AuthRoleMenuSecondaryTreeBo> allTreeBo) {
        allTreeBo.stream().forEach(p -> {
            if (p.getDeep().equals(A)) {
                ArrayList children = new ArrayList();
                allTreeBo.stream().forEach(c -> {
                    if (p.getMenuId().equals(c.getParentID())) {
                        children.add(c);
                    }
                });
                p.setChildren(children);
                if (!CollectionUtils.isEmpty(children)) {
                    p.setHasChild(true);
                }
            }
        });
    }

    private List<AuthRoleMenuSecondaryTreeBo> buildByRecursive(List<AuthRoleMenuSecondaryTreeBo> treeNodes) {
        Collections.sort(treeNodes);
        ArrayList<AuthRoleMenuSecondaryTreeBo> trees = new ArrayList<AuthRoleMenuSecondaryTreeBo>();
        for (AuthRoleMenuSecondaryTreeBo treeNode : treeNodes) {
            if (treeNode.getParentID() != null) continue;
            trees.add(this.findChildren(treeNode, treeNodes));
        }
        Collections.sort(trees);
        return trees;
    }

    private AuthRoleMenuSecondaryTreeBo findChildren(AuthRoleMenuSecondaryTreeBo root, List<AuthRoleMenuSecondaryTreeBo> allMenus) {
        for (AuthRoleMenuSecondaryTreeBo it : allMenus) {
            if (!root.getMenuId().equals(it.getParentID())) continue;
            if (root.getChildren() == null) {
                root.setChildren(new ArrayList());
            }
            root.getChildren().add(this.findChildren(it, allMenus));
        }
        return root;
    }

    private void hasSel(List<AuthRoleMenuSecondaryTreeBo> allTreeBo, List<AuthRoleMenuSecondaryTreeBo> relTreeBo) {
        block0: for (AuthRoleMenuSecondaryTreeBo a : allTreeBo) {
            for (AuthRoleMenuSecondaryTreeBo b : relTreeBo) {
                if (a.getMenuId().equals(b.getMenuId())) {
                    a.setHasSel(true);
                    continue block0;
                }
                a.setHasSel(false);
            }
        }
    }

    private List<AuthRoleMenuSecondaryTreeBo> build(List<SysMenuDo> menuListAllNew) {
        List<AuthRoleMenuSecondaryTreeBo> collect = menuListAllNew.stream().map(e -> {
            AuthRoleMenuSecondaryTreeBo authRoleMenuSecondaryTreeBo = new AuthRoleMenuSecondaryTreeBo();
            authRoleMenuSecondaryTreeBo.setMenuId(e.getMenuId());
            authRoleMenuSecondaryTreeBo.setMenuName(e.getMenuName());
            authRoleMenuSecondaryTreeBo.setRemark(e.getRemark());
            authRoleMenuSecondaryTreeBo.setParentID(e.getParentId());
            authRoleMenuSecondaryTreeBo.setDeep(e.getDeep());
            return authRoleMenuSecondaryTreeBo;
        }).collect(Collectors.toList());
        return collect;
    }

    private ArrayList<SysMenuDo> getSysMenuDos(List<SysMenuDo> menuListAll) {
        ArrayList<SysMenuDo> menuList = new ArrayList<SysMenuDo>();
        for (SysMenuDo s : menuListAll) {
            if (!A.equals(s.getDeep()) && !B.equals(s.getDeep())) continue;
            menuList.add(s);
        }
        return menuList;
    }
}

