/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.user;

import com.tydic.dyc.authority.model.user.ISysUserInfoModel;
import com.tydic.dyc.authority.model.user.qrybo.SysCustUserQryBo;
import com.tydic.dyc.authority.model.user.sub.SysCustUserSubDo;
import com.tydic.dyc.authority.service.user.AuthGetSubUserListService;
import com.tydic.dyc.authority.service.user.bo.AuthGetSubUserListReqBo;
import com.tydic.dyc.authority.service.user.bo.AuthGetSubUserListRspBo;
import com.tydic.dyc.authority.service.user.bo.AuthSubUserBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AUTHORITY_CENTER_DEV/2.0.0/com.tydic.dyc.authority.service.user.AuthGetSubUserListService"})
public class AuthGetSubUserListServiceImpl
implements AuthGetSubUserListService {
    @Autowired
    private ISysUserInfoModel iSysUserInfoModel;

    @PostMapping(value={"getSubUserList"})
    public AuthGetSubUserListRspBo getSubUserList(@RequestBody AuthGetSubUserListReqBo reqBo) {
        AuthGetSubUserListRspBo rspBo = AuthRu.success(AuthGetSubUserListRspBo.class);
        this.validateArg(reqBo);
        SysCustUserQryBo qryBo = new SysCustUserQryBo();
        qryBo.setMainCustId(reqBo.getCustId());
        List<SysCustUserSubDo> custInfoList = this.iSysUserInfoModel.getCustUserList(qryBo);
        List<AuthSubUserBo> DoToBo = AuthRu.jsl(custInfoList, AuthSubUserBo.class);
        rspBo.setSubUserList(DoToBo);
        return rspBo;
    }

    private void validateArg(AuthGetSubUserListReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthGetSubUserListReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getCustId() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[custId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

