/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.role;

import com.tydic.dyc.authority.constants.AuthDicConstant;
import com.tydic.dyc.authority.model.common.sub.SysAuthDistributeSubDo;
import com.tydic.dyc.authority.model.common.sub.SysRoleInfoSubDo;
import com.tydic.dyc.authority.model.organization.ISysOrgInfoModel;
import com.tydic.dyc.authority.model.organization.SysOrgInfoDo;
import com.tydic.dyc.authority.model.organization.qrybo.SysOrgInfoQryBo;
import com.tydic.dyc.authority.model.role.ISysRoleInfoModel;
import com.tydic.dyc.authority.model.role.SysRoleInfoDo;
import com.tydic.dyc.authority.model.user.ISysUserInfoModel;
import com.tydic.dyc.authority.model.user.SysUserInfoDo;
import com.tydic.dyc.authority.model.user.qrybo.SysAdmUserQryBo;
import com.tydic.dyc.authority.model.user.qrybo.SysUserInfoQryBo;
import com.tydic.dyc.authority.service.domainservice.bo.AuthDistributeBo;
import com.tydic.dyc.authority.service.role.AuthDealRoleService;
import com.tydic.dyc.authority.service.role.bo.AuthDealRoleReqBo;
import com.tydic.dyc.authority.service.role.bo.AuthDealRoleRspBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.authority.utils.IdUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AUTHORITY_CENTER_DEV/2.0.0/com.tydic.dyc.authority.service.role.AuthDealRoleService"})
public class AuthDealRoleServiceImpl
implements AuthDealRoleService {
    @Autowired
    private ISysUserInfoModel iSysUserInfoModel;
    @Autowired
    private ISysRoleInfoModel iSysRoleInfoModel;
    @Autowired
    private ISysOrgInfoModel iSysOrgInfoModel;
    private static final String ADD = "1";
    private static final String DELETE = "2";

    @PostMapping(value={"dealRole"})
    public AuthDealRoleRspBo dealRole(@RequestBody AuthDealRoleReqBo reqBo) {
        Serializable userRoleDo;
        AuthDealRoleRspBo rspBo = AuthRu.success(AuthDealRoleRspBo.class);
        this.validateArg(reqBo);
        this.getManageLevel(reqBo);
        SysOrgInfoDo detailDo = new SysOrgInfoDo();
        SysUserInfoDo userInfoDo = new SysUserInfoDo();
        List<Object> oldRoleLis = new ArrayList();
        Map<Object, Object> roleMapper = new HashMap();
        if (reqBo.getUserIdWeb() != null) {
            SysUserInfoQryBo qryBo = new SysUserInfoQryBo();
            qryBo.setUserId(reqBo.getUserIdWeb());
            userInfoDo = this.iSysUserInfoModel.getUserInfoDetails(qryBo);
            if (userInfoDo == null || userInfoDo.getUserId() == null) {
                throw new BaseBusinessException("100001", "\u672a\u67e5\u8be2\u5230\u7528\u6237\u4fe1\u606f");
            }
            qryBo.setDisAgFLagList(Collections.singletonList(AuthDicConstant.DIS_AG_FLAG.ALL_AUTHORITY));
            userRoleDo = this.iSysUserInfoModel.getRoleInfoListByUser(qryBo);
            oldRoleLis = ((SysUserInfoDo)userRoleDo).getUserRoleList();
        } else {
            SysOrgInfoQryBo orgQryBo = new SysOrgInfoQryBo();
            orgQryBo.setOrgId(reqBo.getOrgIdWeb());
            detailDo = this.iSysOrgInfoModel.getOrgInfoDetails(orgQryBo);
            if (detailDo == null || detailDo.getOrgId() == null) {
                throw new BaseBusinessException("100001", "\u672a\u67e5\u8be2\u5230\u673a\u6784\u4fe1\u606f");
            }
            orgQryBo.setOrgTreePath(detailDo.getOrgTreePath());
            orgQryBo.setDisAgFLagList(Collections.singletonList(AuthDicConstant.DIS_AG_FLAG.ALL_AUTHORITY));
            userRoleDo = this.iSysOrgInfoModel.getRoleInfoListByOrg(orgQryBo);
            oldRoleLis = ((SysOrgInfoDo)userRoleDo).getOrgRoleList();
        }
        if (!CollectionUtils.isEmpty(oldRoleLis)) {
            roleMapper = oldRoleLis.stream().collect(Collectors.toMap(SysRoleInfoSubDo::getRoleId, Function.identity(), (e1, e2) -> e2));
        }
        List authDistributeList = reqBo.getAuthDistributeList();
        ArrayList<AuthDistributeBo> addAuthDistributeList = new ArrayList<AuthDistributeBo>();
        ArrayList<AuthDistributeBo> deleteAuthDistributeList = new ArrayList<AuthDistributeBo>();
        for (AuthDistributeBo bo : authDistributeList) {
            if (roleMapper.containsKey(bo.getRoleId()) && DELETE.equals(bo.getOperType())) {
                deleteAuthDistributeList.add(bo);
                continue;
            }
            if (roleMapper.containsKey(bo.getRoleId()) || !ADD.equals(bo.getOperType())) continue;
            addAuthDistributeList.add(bo);
        }
        if (!CollectionUtils.isEmpty(addAuthDistributeList)) {
            this.addRole(addAuthDistributeList, reqBo, userInfoDo, detailDo);
        }
        if (!CollectionUtils.isEmpty(deleteAuthDistributeList)) {
            this.deleteRole(deleteAuthDistributeList, reqBo, userInfoDo, detailDo);
        }
        if (reqBo.getUserIdWeb() != null) {
            this.addDistributRoles(reqBo, addAuthDistributeList);
        }
        return rspBo;
    }

    private void validateArg(AuthDealRoleReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthDealOrgRoleReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getOrgIdWeb() == null && reqBo.getUserIdWeb() == null) {
            throw new BaseBusinessException("100001", "\u673a\u6784Id\u548c\u7528\u6237Id\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getAuthDistributeList())) {
            throw new BaseBusinessException("100001", "\u65b0\u589e\u5217\u8868\u548c\u5220\u9664\u5217\u8868\u4e0d\u80fd\u90fd\u4e3a\u7a7a");
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getAuthDistributeList())) {
            for (AuthDistributeBo bo : reqBo.getAuthDistributeList()) {
                if (bo.getRoleId() == null) {
                    throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[RoleId]\u4e0d\u80fd\u90fd\u4e3a\u7a7a");
                }
                if (!StringUtils.isEmpty((Object)bo.getOperType())) continue;
                throw new BaseBusinessException("100001", "\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u90fd\u4e3a\u7a7a");
            }
        }
    }

    private void getManageLevel(AuthDealRoleReqBo reqBo) {
        if (reqBo.getManagerLevelIn() == null && reqBo.getOrgIdIn() != null) {
            SysOrgInfoQryBo orgInfoQryBo = new SysOrgInfoQryBo();
            orgInfoQryBo.setOrgId(reqBo.getOrgIdIn());
            SysOrgInfoDo orgInfoDetails = this.iSysOrgInfoModel.getOrgInfoDetails(orgInfoQryBo);
            reqBo.setManagerLevelIn(orgInfoDetails.getManageLevel());
        }
    }

    private void addRole(List<AuthDistributeBo> addRoleListWeb, AuthDealRoleReqBo reqBo, SysUserInfoDo userInfoDo, SysOrgInfoDo orgInfoDo) {
        SysUserInfoDo addReqBo = new SysUserInfoDo();
        SysOrgInfoDo addOrgReqBo = new SysOrgInfoDo();
        List<SysAuthDistributeSubDo> addRoleList = AuthRu.jsl(addRoleListWeb, SysAuthDistributeSubDo.class);
        for (SysAuthDistributeSubDo subDo : addRoleList) {
            subDo.setAuthId(IdUtil.nextId());
            subDo.setDisAgFlag(AuthDicConstant.DIS_AG_FLAG.ALL_AUTHORITY);
            subDo.setManageLevel(reqBo.getManagerLevelIn());
            subDo.setCreateOperId(reqBo.getUpdateOperId());
            subDo.setCreateOperName(reqBo.getUpdateOperName());
            subDo.setCreateTime(reqBo.getUpdateTime());
            subDo.setUpdateOperId(reqBo.getUpdateOperId());
            subDo.setUpdateOperName(reqBo.getUpdateOperName());
            subDo.setUpdateTime(reqBo.getUpdateTime());
            if (reqBo.getUserIdWeb() != null) {
                subDo.setTenantId(userInfoDo.getTenantId());
                subDo.setUserId(reqBo.getUserIdWeb());
                subDo.setDisFlag(AuthDicConstant.ROLE_DIS_FLAG.USER);
                continue;
            }
            subDo.setTenantId(orgInfoDo.getTenantId());
            subDo.setOrgTreePath(orgInfoDo.getOrgTreePath());
            subDo.setDisFlag(AuthDicConstant.ROLE_DIS_FLAG.ORG);
            subDo.setUserId(null);
            if (null != subDo.getOrgExtend()) continue;
            subDo.setOrgExtend(0);
        }
        if (reqBo.getUserIdWeb() != null) {
            addReqBo.setAuthDistributeList(addRoleList);
            this.iSysUserInfoModel.addUserRoleList(addReqBo);
        } else if (reqBo.getOrgIdWeb() != null) {
            addOrgReqBo.setAuthDistributeList(addRoleList);
            this.iSysOrgInfoModel.addOrgRoleList(addOrgReqBo);
        }
    }

    private void deleteRole(List<AuthDistributeBo> addRoleListWeb, AuthDealRoleReqBo reqBo, SysUserInfoDo userInfoDo, SysOrgInfoDo orgInfoDo) {
        SysUserInfoDo addReqBo = new SysUserInfoDo();
        SysOrgInfoDo delOrgReqBo = new SysOrgInfoDo();
        ArrayList<SysAuthDistributeSubDo> delRoleList = new ArrayList<SysAuthDistributeSubDo>();
        for (AuthDistributeBo roleSubBo : addRoleListWeb) {
            SysAuthDistributeSubDo subDo = new SysAuthDistributeSubDo();
            subDo.setRoleId(roleSubBo.getRoleId());
            subDo.setUpdateOperId(reqBo.getUpdateOperId());
            subDo.setUpdateOperName(reqBo.getCreateOperName());
            subDo.setUpdateTime(reqBo.getCreateTime());
            subDo.setDelFlag(ADD);
            if (reqBo.getUserIdWeb() != null) {
                subDo.setUserId(reqBo.getUserIdWeb());
            } else {
                subDo.setOrgTreePath(orgInfoDo.getOrgTreePath());
            }
            delRoleList.add(subDo);
        }
        if (reqBo.getUserIdWeb() != null) {
            addReqBo.setAuthDistributeList(delRoleList);
            this.iSysUserInfoModel.updateUserRoleList(addReqBo);
        } else if (reqBo.getOrgIdWeb() != null) {
            delOrgReqBo.setAuthDistributeList(delRoleList);
            this.iSysOrgInfoModel.updateOrgRoleList(delOrgReqBo);
        }
    }

    private void addDistributRoles(AuthDealRoleReqBo reqBo, List<AuthDistributeBo> addSubDo) {
        SysAdmUserQryBo admUserQryBo = new SysAdmUserQryBo();
        admUserQryBo.setUserId(reqBo.getUserIdWeb());
        List admOrgList = new ArrayList();
        admOrgList = this.iSysUserInfoModel.getAdmOrgList(admUserQryBo).getRows();
        if (!CollectionUtils.isEmpty(admOrgList)) {
            SysRoleInfoDo addReqBo = new SysRoleInfoDo();
            ArrayList<SysAuthDistributeSubDo> addAdmList = new ArrayList<SysAuthDistributeSubDo>();
            for (AuthDistributeBo subDo : addSubDo) {
                if ("0".equals(subDo.getRoleType())) continue;
                SysAuthDistributeSubDo addDo = new SysAuthDistributeSubDo();
                addDo.setAuthId(IdUtil.nextId());
                addDo.setManageLevel(reqBo.getManagerLevelIn());
                addDo.setDisAgFlag(AuthDicConstant.DIS_AG_FLAG.ONLY_DISTRIBUTE);
                addDo.setRoleId(subDo.getRoleId());
                addDo.setCreateOperId(reqBo.getUpdateOperId());
                addDo.setCreateOperName(reqBo.getUpdateOperName());
                addDo.setCreateTime(reqBo.getUpdateTime());
                addDo.setUpdateOperId(reqBo.getUpdateOperId());
                addDo.setUpdateOperName(reqBo.getUpdateOperName());
                addDo.setUpdateTime(reqBo.getUpdateTime());
                addDo.setUserId(reqBo.getUserIdWeb());
                addAdmList.add(addDo);
            }
            addReqBo.setAuthDistributeList(addAdmList);
            this.iSysRoleInfoModel.addAuthDistribute(addReqBo);
        }
    }
}

