/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.role;

import com.tydic.dyc.authority.model.menu.ISysMenuModel;
import com.tydic.dyc.authority.model.menu.SysMenuDo;
import com.tydic.dyc.authority.model.menu.qrybo.SysMenuQryBo;
import com.tydic.dyc.authority.model.role.ISysRoleInfoModel;
import com.tydic.dyc.authority.model.role.SysRoleInfoDo;
import com.tydic.dyc.authority.model.role.qrybo.SysRoleInfoQryBo;
import com.tydic.dyc.authority.model.role.sub.SysMenuSubDo;
import com.tydic.dyc.authority.service.role.AuthRoleMenuSecondaryTreeQryService;
import com.tydic.dyc.authority.service.role.bo.AuthRoleMenuSecondaryTreeBo;
import com.tydic.dyc.authority.service.role.bo.AuthRoleMenuSecondaryTreeQryReqBo;
import com.tydic.dyc.authority.service.role.bo.AuthRoleMenuSecondaryTreeQryRspBo;
import com.tydic.dyc.authority.utils.AuthRu;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AUTHORITY_CENTER_DEV/2.0.0/com.tydic.dyc.authority.service.role.AuthRoleMenuSecondaryTreeQryService"})
public class AuthRoleMenuSecondaryTreeQryServiceImpl
implements AuthRoleMenuSecondaryTreeQryService {
    @Autowired
    private ISysRoleInfoModel iSysRoleInfoModel;
    @Autowired
    private ISysMenuModel iSysMenuModel;
    private static final String QRYTYPE = "2";

    @PostMapping(value={"getRoleMenuSecondaryTree"})
    public AuthRoleMenuSecondaryTreeQryRspBo getRoleMenuSecondaryTree(@RequestBody AuthRoleMenuSecondaryTreeQryReqBo reqBo) {
        AuthRoleMenuSecondaryTreeQryRspBo rspBo = new AuthRoleMenuSecondaryTreeQryRspBo();
        SysRoleInfoQryBo qryBo = new SysRoleInfoQryBo();
        qryBo.setRoleId(reqBo.getRoleId());
        qryBo.setApplicationCode(reqBo.getApplicationCode());
        SysRoleInfoDo rspDo = this.iSysRoleInfoModel.getRoleMenuRelList(qryBo);
        List<SysMenuSubDo> sysMenuSubDos = rspDo.getMenuList();
        List<SysMenuDo> menuListRle = AuthRu.jsl(sysMenuSubDos, SysMenuDo.class);
        List<AuthRoleMenuSecondaryTreeBo> relTreeBo = this.build(menuListRle);
        if (QRYTYPE.equals(reqBo.getQryType())) {
            SysMenuQryBo sysMenuQryBo = new SysMenuQryBo();
            sysMenuQryBo.setApplicationCode(reqBo.getApplicationCode());
            List menuListAll = this.iSysMenuModel.getMenuList(sysMenuQryBo).getRows();
            List<AuthRoleMenuSecondaryTreeBo> allTreeBo = this.build(menuListAll);
            this.hasSel(allTreeBo, relTreeBo);
            List<AuthRoleMenuSecondaryTreeBo> authRoleMenuSecondaryTreeBos = this.buildByRecursive(allTreeBo);
            rspBo.setRows(authRoleMenuSecondaryTreeBos);
        } else {
            List<Object> authRoleMenuSecondaryTreeBos = new ArrayList();
            for (AuthRoleMenuSecondaryTreeBo bo : relTreeBo) {
                bo.setHasSel(true);
            }
            if (!CollectionUtils.isEmpty(relTreeBo)) {
                authRoleMenuSecondaryTreeBos = this.buildByRecursive(relTreeBo);
            }
            rspBo.setRows(authRoleMenuSecondaryTreeBos);
        }
        return rspBo;
    }

    private List<AuthRoleMenuSecondaryTreeBo> buildByRecursive(List<AuthRoleMenuSecondaryTreeBo> treeNodes) {
        Collections.sort(treeNodes);
        ArrayList<AuthRoleMenuSecondaryTreeBo> trees = new ArrayList<AuthRoleMenuSecondaryTreeBo>();
        for (AuthRoleMenuSecondaryTreeBo treeNode : treeNodes) {
            if (treeNode.getParentID() != null) continue;
            trees.add(this.findChildren(treeNode, treeNodes));
        }
        Collections.sort(trees);
        return trees;
    }

    private AuthRoleMenuSecondaryTreeBo findChildren(AuthRoleMenuSecondaryTreeBo root, List<AuthRoleMenuSecondaryTreeBo> allMenus) {
        for (AuthRoleMenuSecondaryTreeBo it : allMenus) {
            if (!root.getMenuId().equals(it.getParentID())) continue;
            if (root.getChildren() == null) {
                root.setChildren(new ArrayList());
            }
            root.getChildren().add(this.findChildren(it, allMenus));
            root.setHasChild(true);
        }
        return root;
    }

    private void hasSel(List<AuthRoleMenuSecondaryTreeBo> allTreeBo, List<AuthRoleMenuSecondaryTreeBo> relTreeBo) {
        block0: for (AuthRoleMenuSecondaryTreeBo a : allTreeBo) {
            for (AuthRoleMenuSecondaryTreeBo b : relTreeBo) {
                if (a.getMenuId().equals(b.getMenuId())) {
                    a.setHasSel(true);
                    continue block0;
                }
                a.setHasSel(false);
            }
        }
    }

    private List<AuthRoleMenuSecondaryTreeBo> build(List<SysMenuDo> menuListAllNew) {
        List<AuthRoleMenuSecondaryTreeBo> collect = menuListAllNew.stream().map(e -> {
            AuthRoleMenuSecondaryTreeBo authRoleMenuSecondaryTreeBo = new AuthRoleMenuSecondaryTreeBo();
            authRoleMenuSecondaryTreeBo.setMenuId(e.getMenuId());
            authRoleMenuSecondaryTreeBo.setMenuName(e.getMenuName());
            authRoleMenuSecondaryTreeBo.setRemark(e.getRemark());
            authRoleMenuSecondaryTreeBo.setParentID(e.getParentId());
            authRoleMenuSecondaryTreeBo.setDeep(e.getDeep());
            return authRoleMenuSecondaryTreeBo;
        }).collect(Collectors.toList());
        return collect;
    }
}

