/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.application;

import com.tydic.dyc.authority.model.application.ISysApplicationModel;
import com.tydic.dyc.authority.model.application.SysApplicationDo;
import com.tydic.dyc.authority.service.application.AuthCreateApplicationService;
import com.tydic.dyc.authority.service.application.bo.AuthApplicationInfoBo;
import com.tydic.dyc.authority.service.application.bo.AuthCreateApplicationReqBo;
import com.tydic.dyc.authority.service.application.bo.AuthCreateApplicationRspBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.authority.utils.IdUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AUTHORITY_CENTER_DEV/2.0.0/com.tydic.dyc.authority.service.application.AuthCreateApplicationService"})
public class AuthCreateApplicationServiceImpl
implements AuthCreateApplicationService {
    @Autowired
    private ISysApplicationModel iSysApplicationModel;

    @PostMapping(value={"createApplication"})
    public AuthCreateApplicationRspBo createApplication(@RequestBody AuthCreateApplicationReqBo reqBo) {
        AuthCreateApplicationRspBo rspBo = AuthRu.success(AuthCreateApplicationRspBo.class);
        this.validateArg(reqBo);
        SysApplicationDo reqDo = this.buildDoByBO(reqBo);
        reqDo.setApplicationId(IdUtil.nextId());
        SysApplicationDo rspDo = this.iSysApplicationModel.createApplicationInfo(reqDo);
        AuthApplicationInfoBo applicationInfoBo = AuthRu.js(rspDo, AuthApplicationInfoBo.class);
        rspBo.setAuthApplicationInfoBo(applicationInfoBo);
        return rspBo;
    }

    private SysApplicationDo buildDoByBO(AuthCreateApplicationReqBo reqBo) {
        reqBo.setCreateTime(new Date());
        SysApplicationDo reqDo = AuthRu.js(reqBo, SysApplicationDo.class);
        return reqDo;
    }

    private void validateArg(AuthCreateApplicationReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthCreateApplicationReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

