/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.domainservice;

import com.tydic.dyc.authority.constants.AuthDicConstant;
import com.tydic.dyc.authority.model.common.sub.SysRoleInfoSubDo;
import com.tydic.dyc.authority.model.organization.ISysOrgInfoModel;
import com.tydic.dyc.authority.model.organization.qrybo.SysOrgRoleInfoQryRspBo;
import com.tydic.dyc.authority.model.user.qrybo.SysUserInfoQryBo;
import com.tydic.dyc.authority.service.domainservice.AuthGetDistributePowerRoleListService;
import com.tydic.dyc.authority.service.domainservice.bo.AuthGetDistributePowerRoleListReqBo;
import com.tydic.dyc.authority.service.domainservice.bo.AuthGetDistributePowerRoleListRspBo;
import com.tydic.dyc.authority.service.domainservice.bo.AuthRoleInfoBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AUTHORITY_CENTER_DEV/2.0.0/com.tydic.dyc.authority.service.domainservice.AuthGetDistributePowerRoleListService"})
public class AuthGetDistributePowerRoleListServiceImpl
implements AuthGetDistributePowerRoleListService {
    @Autowired
    private ISysOrgInfoModel iSysOrgInfoModel;

    @PostMapping(value={"getDistributePowerRoleList"})
    public AuthGetDistributePowerRoleListRspBo getDistributePowerRoleList(@RequestBody AuthGetDistributePowerRoleListReqBo reqBo) {
        AuthGetDistributePowerRoleListRspBo rspBo = new AuthGetDistributePowerRoleListRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        if (reqBo.getUserId() == null || reqBo.getOrgId() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2orgId \u6216\u8005 userId\u4e3a\u7a7a");
        }
        SysUserInfoQryBo userRoleInfo = new SysUserInfoQryBo();
        userRoleInfo.setPageSize(-1);
        userRoleInfo.setDisAgFLag(AuthDicConstant.DIS_AG_FLAG.ONLY_DISTRIBUTE);
        userRoleInfo.setUserId(reqBo.getUserId());
        userRoleInfo.setOrgId(reqBo.getOrgId());
        SysOrgRoleInfoQryRspBo sysOrgRoleInfoQryRspBo = this.iSysOrgInfoModel.getDistributePowerRoleList(userRoleInfo);
        List<SysRoleInfoSubDo> userRoleList = sysOrgRoleInfoQryRspBo.getSysRoleInfoSubDos();
        if (!CollectionUtils.isEmpty(userRoleList)) {
            rspBo.setAllRoleList(AuthRu.jsl(userRoleList, AuthRoleInfoBo.class));
        }
        return rspBo;
    }
}

