/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.tenant;

import com.tydic.dyc.authority.model.tenant.ISysTenantModel;
import com.tydic.dyc.authority.model.tenant.SysTenantInfoDo;
import com.tydic.dyc.authority.model.tenant.qrybo.SysTenantInfoQryBo;
import com.tydic.dyc.authority.service.tenant.AuthDisableTenantInfoService;
import com.tydic.dyc.authority.service.tenant.bo.AuthDisableTenantInfoReqBo;
import com.tydic.dyc.authority.service.tenant.bo.AuthDisableTenantInfoRspBo;
import com.tydic.dyc.authority.service.tenant.bo.AuthTenantInfoBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AUTHORITY_CENTER_DEV/2.0.0/com.tydic.dyc.authority.service.tenant.AuthDisableTenantInfoService"})
public class AuthDisableTenantInfoServiceImpl
implements AuthDisableTenantInfoService {
    @Autowired
    private ISysTenantModel iSysTenantModel;

    @PostMapping(value={"disableTenantInfo"})
    public AuthDisableTenantInfoRspBo disableTenantInfo(@RequestBody AuthDisableTenantInfoReqBo reqBo) {
        AuthDisableTenantInfoRspBo rspBo = AuthRu.success(AuthDisableTenantInfoRspBo.class);
        this.validateArg(reqBo);
        SysTenantInfoQryBo qryBo = new SysTenantInfoQryBo();
        qryBo.setTenantId(reqBo.getTenantId());
        SysTenantInfoDo rspDoDetail = this.iSysTenantModel.getTenantInfoDetails(qryBo);
        if (rspDoDetail == null || rspDoDetail.getTenantId() == null) {
            throw new BaseBusinessException("100001", "\u672a\u67e5\u8be2\u5230\u79df\u6237\u4fe1\u606f");
        }
        if ("0".equals(rspDoDetail.getTenantStatus())) {
            return rspBo;
        }
        SysTenantInfoDo reqDo = this.buildDoByBO(reqBo);
        SysTenantInfoDo rspDo = this.iSysTenantModel.modifyTenantInfo(reqDo);
        AuthTenantInfoBo DoToBo = AuthRu.js(rspDo, AuthTenantInfoBo.class);
        rspBo.setTenantInfoBo(DoToBo);
        return rspBo;
    }

    private SysTenantInfoDo buildDoByBO(AuthDisableTenantInfoReqBo reqBo) {
        reqBo.setUpdateTime(new Date());
        SysTenantInfoDo reqDo = AuthRu.js(reqBo, SysTenantInfoDo.class);
        reqDo.setTenantStatus("0");
        return reqDo;
    }

    private void validateArg(AuthDisableTenantInfoReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthCreateTenantInfoReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getTenantId() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[TenantId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

