/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.organization;

import com.tydic.dyc.authority.model.organization.ISysOrgInfoModel;
import com.tydic.dyc.authority.model.organization.qrybo.SysOrgInfoListRspBo;
import com.tydic.dyc.authority.model.organization.qrybo.SysOrgInfoQryBo;
import com.tydic.dyc.authority.model.role.qrybo.SysOrgInfoQryRspBo;
import com.tydic.dyc.authority.service.organization.AuthGetOrgInfoListByRoleService;
import com.tydic.dyc.authority.service.organization.bo.AuthGetOrgInfoListByRoleReqBo;
import com.tydic.dyc.authority.service.organization.bo.AuthGetOrgInfoListByRoleRspBo;
import com.tydic.dyc.authority.service.organization.bo.AuthOrgInfoBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AUTHORITY_CENTER_DEV/2.0.0/com.tydic.dyc.authority.service.organization.AuthGetOrgInfoListByRoleService"})
public class AuthGetOrgInfoListByRoleServiceImpl
implements AuthGetOrgInfoListByRoleService {
    @Autowired
    private ISysOrgInfoModel iSysOrgInfoModel;

    @PostMapping(value={"getOrgInfoListByRole"})
    public AuthGetOrgInfoListByRoleRspBo getOrgInfoListByRole(@RequestBody AuthGetOrgInfoListByRoleReqBo reqBo) {
        AuthGetOrgInfoListByRoleRspBo rspBo = AuthRu.success(AuthGetOrgInfoListByRoleRspBo.class);
        this.validateArg(reqBo);
        SysOrgInfoQryBo orgQryBo = new SysOrgInfoQryBo();
        orgQryBo.setOrgTreePath(reqBo.getTargetOrgTreePath());
        orgQryBo.setMgOrgIdsIn(reqBo.getMgOrgIdsIn());
        orgQryBo.setPageNo(1);
        orgQryBo.setPageNo(-1);
        SysOrgInfoQryRspBo orgPageList = this.iSysOrgInfoModel.getOrgPageList(orgQryBo);
        rspBo.setAllOrgList(AuthRu.jsl(orgPageList.getRows(), AuthOrgInfoBo.class));
        orgQryBo.setRoleIds(reqBo.getRoleIds());
        orgQryBo.setDisAgFLag(reqBo.getDisAgFlag());
        SysOrgInfoListRspBo orgListByRole = this.iSysOrgInfoModel.getOrgListByRole(orgQryBo);
        rspBo.setHasOrgList(AuthRu.jsl(orgListByRole.getRows(), AuthOrgInfoBo.class));
        return rspBo;
    }

    private void validateArg(AuthGetOrgInfoListByRoleReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthGetUserPowerRoleListReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

