/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.role;

import com.tydic.dyc.authority.constants.AuthDicConstant;
import com.tydic.dyc.authority.model.common.sub.SysAuthDistributeSubDo;
import com.tydic.dyc.authority.model.organization.ISysOrgInfoModel;
import com.tydic.dyc.authority.model.organization.SysOrgInfoDo;
import com.tydic.dyc.authority.model.organization.qrybo.SysOrgInfoQryBo;
import com.tydic.dyc.authority.model.role.ISysRoleInfoModel;
import com.tydic.dyc.authority.model.role.SysRoleInfoDo;
import com.tydic.dyc.authority.model.user.ISysUserInfoModel;
import com.tydic.dyc.authority.model.user.qrybo.SysAdmUserQryBo;
import com.tydic.dyc.authority.model.user.sub.SysAdmUserSubDo;
import com.tydic.dyc.authority.service.domainservice.bo.AuthDistributeBo;
import com.tydic.dyc.authority.service.role.AuthDealRoleUserListService;
import com.tydic.dyc.authority.service.role.bo.AuthDealRoleUserListReqBo;
import com.tydic.dyc.authority.service.role.bo.AuthDealRoleUserListRspBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.authority.utils.IdUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AUTHORITY_CENTER_DEV/2.0.0/com.tydic.dyc.authority.service.role.AuthDealRoleUserListService"})
public class AuthDealRoleUserListServiceImpl
implements AuthDealRoleUserListService {
    @Autowired
    private ISysRoleInfoModel iSysRoleInfoModel;
    @Autowired
    private ISysOrgInfoModel iSysOrgInfoModel;
    @Autowired
    private ISysUserInfoModel iSysUserInfoModel;

    @PostMapping(value={"dealRoleUserList"})
    public AuthDealRoleUserListRspBo dealRoleUserList(@RequestBody AuthDealRoleUserListReqBo reqBo) {
        AuthDealRoleUserListRspBo rspBo = AuthRu.success(AuthDealRoleUserListRspBo.class);
        if (CollectionUtils.isEmpty((Collection)reqBo.getAuthDistributeList())) {
            return rspBo;
        }
        this.validateArg(reqBo);
        this.getManageLevel(reqBo);
        SysRoleInfoDo reqDo = AuthRu.js(reqBo, SysRoleInfoDo.class);
        ArrayList<SysAuthDistributeSubDo> addList = new ArrayList<SysAuthDistributeSubDo>();
        ArrayList<SysAuthDistributeSubDo> delList = new ArrayList<SysAuthDistributeSubDo>();
        for (AuthDistributeBo bo : reqBo.getAuthDistributeList()) {
            if ("1".equals(bo.getOperType())) {
                addList.add(AuthRu.js(bo, SysAuthDistributeSubDo.class));
                continue;
            }
            if (!"2".equals(bo.getOperType())) continue;
            delList.add(AuthRu.js(bo, SysAuthDistributeSubDo.class));
        }
        this.deleteRolePower(reqDo, delList);
        this.addRolePower(reqDo, addList);
        if (!"0".equals(reqBo.getRoleType())) {
            this.addDistributRoles(reqDo, addList);
        }
        return rspBo;
    }

    private void addDistributRoles(SysRoleInfoDo reqDo, List<SysAuthDistributeSubDo> addList) {
        if (!CollectionUtils.isEmpty(addList)) {
            List<Long> users = addList.stream().map(e -> e.getUserId()).collect(Collectors.toList());
            SysAdmUserQryBo admUserQryBo = new SysAdmUserQryBo();
            admUserQryBo.setUserIdList(users);
            List<SysAdmUserSubDo> admOrgList = this.iSysUserInfoModel.getAdmOrgList(admUserQryBo);
            List<Object> admUsers = new ArrayList();
            if (!CollectionUtils.isEmpty(admOrgList)) {
                admUsers = admOrgList.stream().map(e -> e.getUserId()).collect(Collectors.toList());
            }
            SysRoleInfoDo addReqBo = new SysRoleInfoDo();
            ArrayList<SysAuthDistributeSubDo> addAdmList = new ArrayList<SysAuthDistributeSubDo>();
            for (SysAuthDistributeSubDo subDo : addList) {
                if (!admUsers.contains(subDo.getUserId())) continue;
                SysAuthDistributeSubDo addDo = new SysAuthDistributeSubDo();
                addDo.setAuthId(IdUtil.nextId());
                addDo.setManageLevel(reqDo.getManageLevel());
                addDo.setDisAgFlag(AuthDicConstant.DIS_AG_FLAG.ONLY_DISTRIBUTE);
                addDo.setRoleId(reqDo.getRoleId());
                addDo.setCreateOperId(reqDo.getUpdateOperId());
                addDo.setCreateOperName(reqDo.getUpdateOperName());
                addDo.setCreateTime(reqDo.getUpdateTime());
                addDo.setUpdateOperId(reqDo.getUpdateOperId());
                addDo.setUpdateOperName(reqDo.getUpdateOperName());
                addDo.setUpdateTime(reqDo.getUpdateTime());
                addDo.setUserId(subDo.getUserId());
                addAdmList.add(addDo);
            }
            addReqBo.setAuthDistributeList(addAdmList);
            this.iSysRoleInfoModel.addAuthDistribute(addReqBo);
        }
    }

    private void getManageLevel(AuthDealRoleUserListReqBo reqBo) {
        if (reqBo.getManageLevel() == null && reqBo.getOrgIdIn() != null) {
            SysOrgInfoQryBo orgInfoQryBo = new SysOrgInfoQryBo();
            orgInfoQryBo.setOrgId(reqBo.getOrgIdIn());
            SysOrgInfoDo orgInfoDetails = this.iSysOrgInfoModel.getOrgInfoDetails(orgInfoQryBo);
            reqBo.setManageLevel(orgInfoDetails.getManageLevel());
        }
    }

    private void addRolePower(SysRoleInfoDo reqDo, List<SysAuthDistributeSubDo> newDoList) {
        SysRoleInfoDo addReqBo = new SysRoleInfoDo();
        for (SysAuthDistributeSubDo subDo : newDoList) {
            subDo.setAuthId(IdUtil.nextId());
            subDo.setManageLevel(reqDo.getManageLevel());
            subDo.setDisAgFlag(AuthDicConstant.DIS_AG_FLAG.ALL_AUTHORITY);
            subDo.setRoleId(reqDo.getRoleId());
            subDo.setDisFlag(AuthDicConstant.ROLE_DIS_FLAG.USER);
            subDo.setCreateOperId(reqDo.getUpdateOperId());
            subDo.setCreateOperName(reqDo.getUpdateOperName());
            subDo.setCreateTime(reqDo.getUpdateTime());
            subDo.setUpdateOperId(reqDo.getUpdateOperId());
            subDo.setUpdateOperName(reqDo.getUpdateOperName());
            subDo.setUpdateTime(reqDo.getUpdateTime());
        }
        addReqBo.setAuthDistributeList(newDoList);
        this.iSysRoleInfoModel.addAuthDistribute(addReqBo);
    }

    private void deleteRolePower(SysRoleInfoDo reqDo, List<SysAuthDistributeSubDo> oldDoList) {
        SysRoleInfoDo deleteDo = new SysRoleInfoDo();
        for (SysAuthDistributeSubDo subDo : oldDoList) {
            subDo.setRoleId(reqDo.getRoleId());
            subDo.setUpdateOperId(reqDo.getUpdateOperId());
            subDo.setUpdateOperName(reqDo.getCreateOperName());
            subDo.setUpdateTime(reqDo.getCreateTime());
            subDo.setDelFlag("1");
        }
        deleteDo.setAuthDistributeList(oldDoList);
        this.iSysRoleInfoModel.updateAuthDistribute(deleteDo);
    }

    private void validateArg(AuthDealRoleUserListReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthDealOrgRoleReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getRoleId() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[RoleId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getAuthDistributeList())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[\u65b0\u589e\u5217\u8868\u548c\u5220\u9664\u5217\u8868]\u4e0d\u80fd\u90fd\u4e3a\u7a7a");
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getAuthDistributeList())) {
            for (AuthDistributeBo bo : reqBo.getAuthDistributeList()) {
                if (bo.getUserId() == null) {
                    throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[UserId]\u4e0d\u80fd\u90fd\u4e3a\u7a7a");
                }
                if (bo.getOperType() != null) continue;
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[OperType]\u4e0d\u80fd\u90fd\u4e3a\u7a7a");
            }
        }
    }
}

