/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.subpage;

import com.tydic.dyc.authority.model.subpage.ISysSubpageModel;
import com.tydic.dyc.authority.model.subpage.SysSubpageDo;
import com.tydic.dyc.authority.model.subpage.qrybo.SysSubpageQryBo;
import com.tydic.dyc.authority.service.subpage.AuthDisableSubpageService;
import com.tydic.dyc.authority.service.subpage.bo.AuthDisableSubpageReqBo;
import com.tydic.dyc.authority.service.subpage.bo.AuthDisableSubpageRspBo;
import com.tydic.dyc.authority.service.subpage.bo.AuthSubpageInfoBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AUTHORITY_CENTER_DEV/2.0.0/com.tydic.dyc.authority.service.subpage.AuthDisableSubpageService"})
public class AuthDisableSubpageServiceImpl
implements AuthDisableSubpageService {
    @Autowired
    private ISysSubpageModel iSysSubpageModel;

    @PostMapping(value={"disableSubpage"})
    public AuthDisableSubpageRspBo disableSubpage(@RequestBody AuthDisableSubpageReqBo reqBo) {
        AuthDisableSubpageRspBo rspBo = AuthRu.success(AuthDisableSubpageRspBo.class);
        this.validateArg(reqBo);
        SysSubpageQryBo qryBo = new SysSubpageQryBo();
        ArrayList<Long> menuIds = new ArrayList<Long>();
        if (reqBo.getPageId() != null) {
            menuIds.add(reqBo.getPageId());
        } else {
            menuIds.addAll(reqBo.getPageIds());
        }
        qryBo.setPageIds(menuIds);
        SysSubpageDo reqDo = this.buildDoByBO(reqBo);
        SysSubpageDo rspDo = this.iSysSubpageModel.modifySubpageInfo(reqDo, qryBo);
        AuthSubpageInfoBo DoToBo = AuthRu.js(rspDo, AuthSubpageInfoBo.class);
        rspBo.setSubpageInfoBo(DoToBo);
        return rspBo;
    }

    private SysSubpageDo buildDoByBO(AuthDisableSubpageReqBo reqBo) {
        reqBo.setUpdateTime(new Date());
        SysSubpageDo reqDo = AuthRu.js(reqBo, SysSubpageDo.class);
        reqDo.setPageStatus("0");
        return reqDo;
    }

    private void validateArg(AuthDisableSubpageReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthCreateMenuReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getPageId() == null && CollectionUtils.isEmpty((Collection)reqBo.getPageIds())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[PageId\u6216PageIds]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

