/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.organization;

import com.tydic.dyc.authority.model.organization.ISysOrgInfoModel;
import com.tydic.dyc.authority.model.organization.SysOrgInfoDo;
import com.tydic.dyc.authority.model.organization.qrybo.SysOrgInfoQryBo;
import com.tydic.dyc.authority.model.organization.sub.SysOrgTagRelSubDo;
import com.tydic.dyc.authority.model.orgtype.ISysOrgTypeModel;
import com.tydic.dyc.authority.model.orgtype.SysOrgTypeDo;
import com.tydic.dyc.authority.model.orgtype.qrybo.SysOrgTypeQryBo;
import com.tydic.dyc.authority.service.organization.AuthCreateOrgInfoService;
import com.tydic.dyc.authority.service.organization.bo.AuthCreateOrgInfoReqBo;
import com.tydic.dyc.authority.service.organization.bo.AuthCreateOrgInfoRspBo;
import com.tydic.dyc.authority.service.organization.bo.AuthOrgInfoBo;
import com.tydic.dyc.authority.service.organization.bo.AuthOrgTagRelBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.authority.utils.IdUtil;
import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AUTHORITY_CENTER_DEV/2.0.0/com.tydic.dyc.authority.service.organization.AuthCreateOrgInfoService"})
public class AuthCreateOrgInfoServiceImpl
implements AuthCreateOrgInfoService {
    @Autowired
    private ISysOrgInfoModel iSysOrgInfoModel;
    @Autowired
    private ISysOrgTypeModel iSysOrgTypeModel;
    private static final Long DEPARTMENT = 3L;
    private static final int DEFAULT_MANAGE_LEVEL = 10;

    @PostMapping(value={"createOrgInfo"})
    public AuthCreateOrgInfoRspBo createOrgInfo(@RequestBody AuthCreateOrgInfoReqBo reqBo) {
        AuthCreateOrgInfoRspBo rspBo = AuthRu.success(AuthCreateOrgInfoRspBo.class);
        this.validateArg(reqBo);
        SysOrgInfoQryBo parentQryBo = new SysOrgInfoQryBo();
        parentQryBo.setOrgId(reqBo.getParentId());
        SysOrgInfoDo parentOrgDo = this.iSysOrgInfoModel.getOrgInfoDetails(parentQryBo);
        if (parentOrgDo == null || parentOrgDo.getTenantId() == null) {
            throw new BaseBusinessException("100001", "\u672a\u67e5\u8be2\u5230\u673a\u6784\u4fe1\u606f");
        }
        SysOrgInfoDo reqDo = this.buildDoByBO(reqBo, parentOrgDo);
        SysOrgInfoDo rspDo = this.iSysOrgInfoModel.createOrgInfo(reqDo);
        AuthOrgInfoBo DoToBo = AuthRu.js(rspDo, AuthOrgInfoBo.class);
        rspBo.setOrgInfoBo(DoToBo);
        return rspBo;
    }

    private SysOrgInfoDo buildDoByBO(AuthCreateOrgInfoReqBo reqBo, SysOrgInfoDo parentOrgDo) {
        reqBo.setCreateTime(new Date());
        reqBo.setUpdateTime(reqBo.getCreateTime());
        SysOrgInfoDo reqDo = AuthRu.js(reqBo, SysOrgInfoDo.class);
        reqDo.setOrgId(IdUtil.nextId());
        String treePath = parentOrgDo.getOrgTreePath() + reqDo.getOrgId() + "-";
        reqDo.setOrgTreePath(treePath);
        reqDo.setDeep(parentOrgDo.getDeep() + 1);
        reqDo.setTenantId(parentOrgDo.getTenantId());
        reqDo.setDelFlag("0");
        if (!reqBo.getOrgType().equals(DEPARTMENT)) {
            reqDo.setCompanyId(reqDo.getOrgId());
        } else {
            reqDo.setCompanyId(parentOrgDo.getCompanyId());
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getOrgTagList())) {
            ArrayList<SysOrgTagRelSubDo> orgTagRelSubDoList = new ArrayList<SysOrgTagRelSubDo>();
            for (AuthOrgTagRelBo orgTagRelBo : reqBo.getOrgTagList()) {
                SysOrgTagRelSubDo orgTagRelSubDo = AuthRu.js(orgTagRelBo, SysOrgTagRelSubDo.class);
                orgTagRelSubDo.setDelFlag("0");
                if (null == orgTagRelSubDo.getRelId()) {
                    orgTagRelSubDo.setRelId(IdUtil.nextId());
                }
                if (null == orgTagRelSubDo.getOrgId()) {
                    orgTagRelSubDo.setOrgId(reqDo.getOrgId());
                }
                orgTagRelSubDo.setCreateTime(new Date());
                orgTagRelSubDoList.add(orgTagRelSubDo);
            }
            reqDo.setOrgTagList(orgTagRelSubDoList);
        }
        reqDo.setManageLevel(10);
        if (null != reqDo.getOrgType()) {
            SysOrgTypeQryBo sysOrgTypeQryBo = new SysOrgTypeQryBo();
            sysOrgTypeQryBo.setOrgTypeId(reqDo.getOrgType());
            BasePageRspBo<SysOrgTypeDo> orgTypePageList = this.iSysOrgTypeModel.getOrgTypePageList(sysOrgTypeQryBo);
            if (!CollectionUtils.isEmpty((Collection)orgTypePageList.getRows()) && null != ((SysOrgTypeDo)orgTypePageList.getRows().get(0)).getManageLevel()) {
                reqDo.setManageLevel(((SysOrgTypeDo)orgTypePageList.getRows().get(0)).getManageLevel());
            }
        }
        return reqDo;
    }

    private void validateArg(AuthCreateOrgInfoReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthCreateOrgInfoReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getParentId() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[\u7236\u673a\u6784Id parentId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

