/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.organization;

import com.tydic.dyc.authority.model.organization.ISysOrgInfoModel;
import com.tydic.dyc.authority.model.organization.SysOrgInfoDo;
import com.tydic.dyc.authority.model.organization.qrybo.SysOrgInfoQryBo;
import com.tydic.dyc.authority.service.organization.AuthDisableOrgInfoService;
import com.tydic.dyc.authority.service.organization.bo.AuthDisableOrgInfoReqBo;
import com.tydic.dyc.authority.service.organization.bo.AuthDisableOrgInfoRspBo;
import com.tydic.dyc.authority.service.organization.bo.AuthOrgInfoBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AUTHORITY_CENTER_DEV/2.0.0/com.tydic.dyc.authority.service.organization.AuthDisableOrgInfoService"})
public class AuthDisableOrgInfoServiceImpl
implements AuthDisableOrgInfoService {
    @Autowired
    private ISysOrgInfoModel iSysOrgInfoModel;

    @PostMapping(value={"disableOrgInfo"})
    public AuthDisableOrgInfoRspBo disableOrgInfo(@RequestBody AuthDisableOrgInfoReqBo reqBo) {
        AuthDisableOrgInfoRspBo rspBo = AuthRu.success(AuthDisableOrgInfoRspBo.class);
        this.validateArg(reqBo);
        SysOrgInfoDo reqDo = this.buildDoByBO(reqBo);
        SysOrgInfoQryBo orgQryBo = new SysOrgInfoQryBo();
        orgQryBo.setOrgId(reqBo.getOrgId());
        SysOrgInfoDo orgInfoDo = this.iSysOrgInfoModel.getOrgInfoDetails(orgQryBo);
        if (orgInfoDo == null || orgInfoDo.getOrgId() == null) {
            throw new BaseBusinessException("100001", "\u672a\u67e5\u8be2\u5230\u673a\u6784\u4fe1\u606f");
        }
        if ("0".equals(orgInfoDo.getOrgStatus())) {
            return rspBo;
        }
        SysOrgInfoDo rspDo = this.iSysOrgInfoModel.modifyOrgInfo(reqDo);
        AuthOrgInfoBo DoToBo = AuthRu.js(rspDo, AuthOrgInfoBo.class);
        rspBo.setOrgInfoBo(DoToBo);
        return rspBo;
    }

    private SysOrgInfoDo buildDoByBO(AuthDisableOrgInfoReqBo reqBo) {
        reqBo.setUpdateTime(reqBo.getUpdateTime());
        SysOrgInfoDo reqDo = AuthRu.js(reqBo, SysOrgInfoDo.class);
        reqDo.setOrgStatus("0");
        return reqDo;
    }

    private void validateArg(AuthDisableOrgInfoReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthCreateOrgInfoReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getOrgId() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[orgId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

