/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.role;

import com.tydic.dyc.authority.model.role.ISysRoleInfoModel;
import com.tydic.dyc.authority.model.role.SysRoleInfoDo;
import com.tydic.dyc.authority.model.role.qrybo.SysRoleInfoQryBo;
import com.tydic.dyc.authority.service.domainservice.bo.AuthRoleInfoBo;
import com.tydic.dyc.authority.service.role.AuthGetRoleInfoDetailService;
import com.tydic.dyc.authority.service.role.bo.AuthGetRoleInfoDetailReqBo;
import com.tydic.dyc.authority.service.role.bo.AuthGetRoleInfoDetailRspBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AUTHORITY_CENTER_DEV/2.0.0/com.tydic.dyc.authority.service.role.AuthGetRoleInfoDetailService"})
public class AuthGetRoleInfoDetailServiceImpl
implements AuthGetRoleInfoDetailService {
    @Autowired
    private ISysRoleInfoModel iSysRoleInfoModel;

    @PostMapping(value={"getRoleInfoDetail"})
    public AuthGetRoleInfoDetailRspBo getRoleInfoDetail(@RequestBody AuthGetRoleInfoDetailReqBo reqBo) {
        SysRoleInfoDo rspDo;
        AuthGetRoleInfoDetailRspBo rspBo = AuthRu.success(AuthGetRoleInfoDetailRspBo.class);
        this.validateArg(reqBo);
        SysRoleInfoQryBo qryBo = new SysRoleInfoQryBo();
        qryBo.setRoleId(reqBo.getRoleId());
        if (reqBo.getRoleId() == null) {
            qryBo.setRoleName(reqBo.getRoleName());
        }
        if ((rspDo = this.iSysRoleInfoModel.getRoleInfoDetails(qryBo)) == null || rspDo.getRoleId() == null) {
            return rspBo;
        }
        AuthRoleInfoBo DoToBo = AuthRu.js(rspDo, AuthRoleInfoBo.class);
        rspBo.setRoleInfoBo(DoToBo);
        return rspBo;
    }

    private void validateArg(AuthGetRoleInfoDetailReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthDeleteRoleInfoReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getRoleId() == null && StringUtils.isEmpty((Object)reqBo.getRoleName())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[orgId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

