/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.domainservice;

import com.tydic.dyc.authority.constants.AuthConstant;
import com.tydic.dyc.authority.constants.AuthDicConstant;
import com.tydic.dyc.authority.model.common.sub.SysAuthDistributeSubDo;
import com.tydic.dyc.authority.model.organization.ISysOrgInfoModel;
import com.tydic.dyc.authority.model.organization.SysOrgInfoDo;
import com.tydic.dyc.authority.model.organization.qrybo.SysOrgInfoQryBo;
import com.tydic.dyc.authority.model.organization.sub.SysOrgTagRelSubDo;
import com.tydic.dyc.authority.model.user.ISysUserInfoModel;
import com.tydic.dyc.authority.model.user.SysUserInfoDo;
import com.tydic.dyc.authority.model.user.sub.SysCustExtMapSubDo;
import com.tydic.dyc.authority.model.user.sub.SysCustInfoSubDo;
import com.tydic.dyc.authority.model.user.sub.SysUserTagRelSubDo;
import com.tydic.dyc.authority.service.domainservice.AuthEnterpriseUserRegisterService;
import com.tydic.dyc.authority.service.domainservice.bo.AuthDistributeBo;
import com.tydic.dyc.authority.service.domainservice.bo.AuthEnterpriseRegisterBo;
import com.tydic.dyc.authority.service.domainservice.bo.AuthEnterpriseUserRegisterReqBo;
import com.tydic.dyc.authority.service.domainservice.bo.AuthEnterpriseUserRegisterRspBo;
import com.tydic.dyc.authority.service.domainservice.bo.AuthUserRegisterInfoBo;
import com.tydic.dyc.authority.service.organization.bo.AuthOrgInfoBo;
import com.tydic.dyc.authority.service.organization.bo.AuthOrgTagRelBo;
import com.tydic.dyc.authority.service.user.bo.AuthCustExtMapBo;
import com.tydic.dyc.authority.service.user.bo.AuthUserInfoBo;
import com.tydic.dyc.authority.service.user.bo.AuthUserTagRelBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.authority.utils.IdUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AUTHORITY_CENTER_DEV/2.0.0/com.tydic.dyc.authority.service.domainservice.AuthEnterpriseUserRegisterService"})
public class AuthEnterpriseUserRegisterServiceImpl
implements AuthEnterpriseUserRegisterService {
    @Autowired
    private ISysOrgInfoModel iSysOrgInfoModel;
    @Autowired
    private ISysUserInfoModel iSysUserInfoModel;
    private static final Long DEPARTMENT = 3L;

    @PostMapping(value={"dealEnterpriseUserRegister"})
    public AuthEnterpriseUserRegisterRspBo dealEnterpriseUserRegister(@RequestBody AuthEnterpriseUserRegisterReqBo reqBo) {
        this.validateArg(reqBo);
        SysOrgInfoDo parentOrgDo = this.getSysOrgInfoDo(reqBo);
        AuthOrgInfoBo authOrgInfoBo = this.createOrg(reqBo, parentOrgDo);
        AuthUserInfoBo authUserInfoBo = this.createUser(reqBo, authOrgInfoBo);
        return this.getRspBo(authOrgInfoBo, authUserInfoBo);
    }

    private SysOrgInfoDo getSysOrgInfoDo(AuthEnterpriseUserRegisterReqBo reqBo) {
        SysOrgInfoQryBo parentQryBo = new SysOrgInfoQryBo();
        parentQryBo.setOrgId(reqBo.getAuthEnterpriseRegisterBo().getParentId());
        SysOrgInfoDo parentOrgDo = this.iSysOrgInfoModel.getOrgInfoDetails(parentQryBo);
        if (parentOrgDo == null || parentOrgDo.getTenantId() == null) {
            throw new BaseBusinessException("100001", "\u672a\u67e5\u8be2\u5230\u673a\u6784\u4fe1\u606f");
        }
        return parentOrgDo;
    }

    private AuthEnterpriseUserRegisterRspBo getRspBo(AuthOrgInfoBo authOrgInfoBo, AuthUserInfoBo authUserInfoBo) {
        AuthEnterpriseUserRegisterRspBo rspBo = AuthRu.success(AuthEnterpriseUserRegisterRspBo.class);
        rspBo.setOrgInfoBo(authOrgInfoBo);
        rspBo.setUserInfoBo(authUserInfoBo);
        return rspBo;
    }

    private AuthUserInfoBo createUser(AuthEnterpriseUserRegisterReqBo reqBo, AuthOrgInfoBo authOrgInfoBo) {
        SysUserInfoDo sysUserInfoReqDo = this.convertUserDo(reqBo.getAuthUserRegisterInfoBo(), authOrgInfoBo);
        SysUserInfoDo sysUserInfoRspDo = this.iSysUserInfoModel.createUserInfo(sysUserInfoReqDo);
        if (!CollectionUtils.isEmpty(sysUserInfoReqDo.getAuthDistributeList())) {
            this.iSysUserInfoModel.addUserRoleList(sysUserInfoReqDo);
        }
        AuthUserInfoBo authUserInfoBo = AuthRu.js(sysUserInfoRspDo, AuthUserInfoBo.class);
        return authUserInfoBo;
    }

    private AuthOrgInfoBo createOrg(AuthEnterpriseUserRegisterReqBo reqBo, SysOrgInfoDo parentOrgDo) {
        SysOrgInfoDo sysOrgInfoReqDo = this.convertOrgDo(reqBo.getAuthEnterpriseRegisterBo(), parentOrgDo);
        SysOrgInfoDo sysOrgInfoRspDo = this.iSysOrgInfoModel.createOrgInfo(sysOrgInfoReqDo);
        AuthOrgInfoBo authOrgInfoBo = AuthRu.js(sysOrgInfoRspDo, AuthOrgInfoBo.class);
        return authOrgInfoBo;
    }

    private SysUserInfoDo convertUserDo(AuthUserRegisterInfoBo reqBo, AuthOrgInfoBo authOrgInfoBo) {
        Serializable subDo;
        reqBo.setCreateTime(new Date());
        reqBo.setUpdateTime(reqBo.getCreateTime());
        SysUserInfoDo reqDo = AuthRu.js(reqBo, SysUserInfoDo.class);
        reqDo.setOrgId(authOrgInfoBo.getOrgId());
        reqDo.setOrgTreePath(authOrgInfoBo.getOrgTreePath());
        reqDo.setDelFlag("0");
        if (reqBo.getCustInfo() != null && reqBo.getCustId() == null) {
            SysCustInfoSubDo custSubDo = AuthRu.js(reqBo.getCustInfo(), SysCustInfoSubDo.class);
            reqDo.setCustId(IdUtil.nextId());
            reqDo.setMainCustId(reqDo.getCustId());
            custSubDo.setCustId(reqDo.getCustId());
            custSubDo.setDelFlag("0");
            custSubDo.setCreateOperId(reqDo.getCreateOperId());
            custSubDo.setCreateOperName(reqDo.getCreateOperName());
            custSubDo.setCreateTime(reqDo.getCreateTime());
            custSubDo.setUpdateOperId(reqDo.getUpdateOperId());
            custSubDo.setUpdateOperName(reqDo.getCreateOperName());
            custSubDo.setUpdateTime(reqDo.getCreateTime());
            reqDo.setCustInfo(custSubDo);
            if (!CollectionUtils.isEmpty((Collection)reqBo.getCustExtMapList())) {
                ArrayList<SysCustExtMapSubDo> sysCustExtMapList = new ArrayList<SysCustExtMapSubDo>();
                for (AuthCustExtMapBo custBo : reqBo.getCustExtMapList()) {
                    SysCustExtMapSubDo extSubDo = AuthRu.js(custBo, SysCustExtMapSubDo.class);
                    extSubDo.setCustId(reqDo.getCustId());
                    extSubDo.setCreateOperId(reqDo.getCreateOperId());
                    extSubDo.setCreateOperName(reqDo.getCreateOperName());
                    extSubDo.setCreateTime(reqDo.getCreateTime());
                    extSubDo.setUpdateOperId(reqDo.getUpdateOperId());
                    extSubDo.setUpdateOperName(reqDo.getCreateOperName());
                    extSubDo.setUpdateTime(reqDo.getCreateTime());
                    sysCustExtMapList.add(extSubDo);
                }
                reqDo.setCustExtMapList(sysCustExtMapList);
            }
        }
        reqDo.setUserId(IdUtil.nextId());
        if (!CollectionUtils.isEmpty((Collection)reqBo.getUserTagRelList())) {
            ArrayList<SysUserTagRelSubDo> sysUserTagRelList = new ArrayList<SysUserTagRelSubDo>();
            for (AuthUserTagRelBo bo : reqBo.getUserTagRelList()) {
                subDo = AuthRu.js(bo, SysUserTagRelSubDo.class);
                ((SysUserTagRelSubDo)subDo).setRelId(IdUtil.nextId());
                ((SysUserTagRelSubDo)subDo).setUserId(reqDo.getUserId());
                ((SysUserTagRelSubDo)subDo).setDelFlag("0");
                ((SysUserTagRelSubDo)subDo).setCreateOperId(reqDo.getCreateOperId());
                ((SysUserTagRelSubDo)subDo).setCreateOperName(reqDo.getCreateOperName());
                ((SysUserTagRelSubDo)subDo).setCreateTime(reqDo.getCreateTime());
                ((SysUserTagRelSubDo)subDo).setUpdateOperId(reqDo.getUpdateOperId());
                ((SysUserTagRelSubDo)subDo).setUpdateOperName(reqDo.getCreateOperName());
                ((SysUserTagRelSubDo)subDo).setUpdateTime(reqDo.getCreateTime());
                sysUserTagRelList.add((SysUserTagRelSubDo)subDo);
            }
            reqDo.setUserTagRelList(sysUserTagRelList);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getAuthDistributeList())) {
            ArrayList<SysAuthDistributeSubDo> authDistributeList = new ArrayList<SysAuthDistributeSubDo>();
            for (AuthUserTagRelBo bo : reqBo.getAuthDistributeList()) {
                subDo = AuthRu.js(bo, SysAuthDistributeSubDo.class);
                ((SysAuthDistributeSubDo)subDo).setAuthId(IdUtil.nextId());
                ((SysAuthDistributeSubDo)subDo).setDisFlag(AuthConstant.ROLE_DIS_FLAG.USER);
                ((SysAuthDistributeSubDo)subDo).setUserId(reqDo.getUserId());
                ((SysAuthDistributeSubDo)subDo).setDelFlag("0");
                ((SysAuthDistributeSubDo)subDo).setCreateOperId(reqDo.getCreateOperId());
                ((SysAuthDistributeSubDo)subDo).setCreateOperName(reqDo.getCreateOperName());
                ((SysAuthDistributeSubDo)subDo).setCreateTime(reqDo.getCreateTime());
                ((SysAuthDistributeSubDo)subDo).setUpdateOperId(reqDo.getUpdateOperId());
                ((SysAuthDistributeSubDo)subDo).setUpdateOperName(reqDo.getCreateOperName());
                ((SysAuthDistributeSubDo)subDo).setUpdateTime(reqDo.getCreateTime());
                ((SysAuthDistributeSubDo)subDo).setDisAgFlag(AuthDicConstant.DIS_AG_FLAG.ALL_AUTHORITY);
                authDistributeList.add((SysAuthDistributeSubDo)subDo);
            }
            reqDo.setAuthDistributeList(authDistributeList);
        }
        return reqDo;
    }

    private SysOrgInfoDo convertOrgDo(AuthEnterpriseRegisterBo reqBo, SysOrgInfoDo parentOrgDo) {
        reqBo.setCreateTime(new Date());
        reqBo.setUpdateTime(reqBo.getCreateTime());
        SysOrgInfoDo reqDo = AuthRu.js(reqBo, SysOrgInfoDo.class);
        reqDo.setOrgId(IdUtil.nextId());
        String treePath = parentOrgDo.getOrgTreePath() + reqDo.getOrgId() + "-";
        reqDo.setOrgTreePath(treePath);
        reqDo.setDeep(parentOrgDo.getDeep() + 1);
        reqDo.setTenantId(parentOrgDo.getTenantId());
        reqDo.setDelFlag("0");
        if (!reqBo.getOrgType().equals(DEPARTMENT)) {
            reqDo.setCompanyId(reqDo.getOrgId());
        } else {
            reqDo.setCompanyId(parentOrgDo.getCompanyId());
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getOrgTagList())) {
            ArrayList<SysOrgTagRelSubDo> orgTagRelSubDoList = new ArrayList<SysOrgTagRelSubDo>();
            for (AuthOrgTagRelBo orgTagRelBo : reqBo.getOrgTagList()) {
                SysOrgTagRelSubDo orgTagRelSubDo = AuthRu.js(orgTagRelBo, SysOrgTagRelSubDo.class);
                orgTagRelSubDo.setDelFlag("0");
                if (null == orgTagRelSubDo.getRelId()) {
                    orgTagRelSubDo.setRelId(IdUtil.nextId());
                }
                if (null == orgTagRelSubDo.getOrgId()) {
                    orgTagRelSubDo.setOrgId(reqDo.getOrgId());
                }
                orgTagRelSubDo.setCreateTime(new Date());
                orgTagRelSubDoList.add(orgTagRelSubDo);
            }
            reqDo.setOrgTagList(orgTagRelSubDoList);
        }
        return reqDo;
    }

    private void validateArg(AuthEnterpriseUserRegisterReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getAuthEnterpriseRegisterBo()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4f01\u4e1a\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getAuthEnterpriseRegisterBo().getParentId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4f01\u4e1a\u4fe1\u606f\u7236\u673a\u6784ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getAuthUserRegisterInfoBo()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u7528\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getAuthUserRegisterInfoBo().getCustInfo() && null == reqBo.getAuthUserRegisterInfoBo().getCustId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5ba2\u6237\u4fe1\u606f\u548c\u5ba2\u6237ID\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getAuthUserRegisterInfoBo().getAuthDistributeList())) {
            for (AuthDistributeBo bo : reqBo.getAuthUserRegisterInfoBo().getAuthDistributeList()) {
                if (bo.getRoleId() != null) continue;
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u89d2\u8272ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getAuthUserRegisterInfoBo().getUserTagRelList())) {
            for (AuthDistributeBo bo : reqBo.getAuthUserRegisterInfoBo().getUserTagRelList()) {
                if (bo.getTagId() != null) continue;
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u8eab\u4efdID\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }
}

