/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.user;

import com.tydic.dyc.authority.constants.AuthConstant;
import com.tydic.dyc.authority.model.authDistribute.SysAuthDistributeDo;
import com.tydic.dyc.authority.model.user.ISysUserInfoModel;
import com.tydic.dyc.authority.model.user.SysUserInfoDo;
import com.tydic.dyc.authority.model.user.qrybo.AuthCustInfoSyncReqBo;
import com.tydic.dyc.authority.model.user.sub.SysCustInfoSubDo;
import com.tydic.dyc.authority.model.user.sub.SysUserTagRelSubDo;
import com.tydic.dyc.authority.service.domainservice.bo.AuthDistributeBo;
import com.tydic.dyc.authority.service.user.AuthCustInfoSyncService;
import com.tydic.dyc.authority.service.user.bo.AuthCustInfoBo;
import com.tydic.dyc.authority.service.user.bo.AuthCustInfoSyncServiceReqBo;
import com.tydic.dyc.authority.service.user.bo.AuthCustInfoSyncServiceRspBo;
import com.tydic.dyc.authority.service.user.bo.AuthUserInfoBo;
import com.tydic.dyc.authority.service.user.bo.AuthUserTagRelBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.authority.utils.IdUtil;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AUTHORITY_CENTER_DEV/2.0.0/com.tydic.dyc.authority.service.user.AuthCustInfoSyncService"})
public class AuthCustInfoSyncServiceImpl
implements AuthCustInfoSyncService {
    @Autowired
    private ISysUserInfoModel iSysUserInfoModel;
    @Value(value="${password.default:123456}")
    private String initialPassword;

    @PostMapping(value={"syncCuStInfo"})
    public AuthCustInfoSyncServiceRspBo syncCuStInfo(@RequestBody AuthCustInfoSyncServiceReqBo reqBo) {
        List<AuthCustInfoBo> addAuthCustInfoBos = reqBo.getCustInfoBos().stream().filter(authCustInfoBo -> AuthConstant.SyncDealType.ADD.equals(authCustInfoBo.getDealType())).collect(Collectors.toList());
        List<AuthCustInfoBo> updateAuthCustInfoBos = reqBo.getCustInfoBos().stream().filter(authCustInfoBo -> AuthConstant.SyncDealType.UPDATE.equals(authCustInfoBo.getDealType())).collect(Collectors.toList());
        List<AuthUserInfoBo> addAuthUserInfoBos = reqBo.getUserInfoBos().stream().filter(authUserInfoBo -> AuthConstant.SyncDealType.ADD.equals(authUserInfoBo.getDealType())).collect(Collectors.toList());
        List<AuthUserInfoBo> updateAuthUserInfoBos = reqBo.getUserInfoBos().stream().filter(authUserInfoBo -> AuthConstant.SyncDealType.UPDATE.equals(authUserInfoBo.getDealType())).collect(Collectors.toList());
        List<AuthUserInfoBo> deleteAuthUserInfoBos = reqBo.getUserInfoBos().stream().filter(authUserInfoBo -> AuthConstant.SyncDealType.DELETE.equals(authUserInfoBo.getDealType())).collect(Collectors.toList());
        List<AuthUserTagRelBo> addAuthUserTagRelBos = reqBo.getUserTagRelBos().stream().filter(authUserTagRelBo -> AuthConstant.SyncDealType.ADD.equals(authUserTagRelBo.getDealType())).collect(Collectors.toList());
        List<AuthUserTagRelBo> updateAuthUserTagRelBos = reqBo.getUserTagRelBos().stream().filter(authUserTagRelBo -> AuthConstant.SyncDealType.UPDATE.equals(authUserTagRelBo.getDealType())).collect(Collectors.toList());
        List<AuthDistributeBo> addAuthDistributeBos = reqBo.getAuthDistributeBos().stream().filter(authDistributeBo -> AuthConstant.SyncDealType.ADD.equals(authDistributeBo.getDealType())).collect(Collectors.toList());
        List<AuthDistributeBo> updateAuthDistributeBos = reqBo.getAuthDistributeBos().stream().filter(authDistributeBo -> AuthConstant.SyncDealType.UPDATE.equals(authDistributeBo.getDealType())).collect(Collectors.toList());
        this.dealAdd(addAuthCustInfoBos, addAuthUserInfoBos, addAuthUserTagRelBos, addAuthDistributeBos);
        this.dealUpdate(updateAuthCustInfoBos, updateAuthUserInfoBos, updateAuthUserTagRelBos, updateAuthDistributeBos);
        this.dealDelete(deleteAuthUserInfoBos);
        return new AuthCustInfoSyncServiceRspBo();
    }

    private void dealUpdate(List<AuthCustInfoBo> updateAuthCustInfoBos, List<AuthUserInfoBo> updateAuthUserInfoBos, List<AuthUserTagRelBo> updateAuthUserTagRelBos, List<AuthDistributeBo> updateAuthDistributeBos) {
        AuthCustInfoSyncReqBo authCustInfoSyncReqBo = new AuthCustInfoSyncReqBo();
        authCustInfoSyncReqBo.setCustInfoBos(AuthRu.jsl(updateAuthCustInfoBos, SysCustInfoSubDo.class));
        authCustInfoSyncReqBo.setUserInfoBos(AuthRu.jsl(updateAuthUserInfoBos, SysUserInfoDo.class));
        authCustInfoSyncReqBo.setUserTagRelBos(AuthRu.jsl(updateAuthUserTagRelBos, SysUserTagRelSubDo.class));
        authCustInfoSyncReqBo.setAuthDistributeBos(AuthRu.jsl(updateAuthDistributeBos, SysAuthDistributeDo.class));
        this.iSysUserInfoModel.updateSyncCustInfo(authCustInfoSyncReqBo);
    }

    private void dealDelete(List<AuthUserInfoBo> deleteAuthUserInfoBos) {
        if (!CollectionUtils.isEmpty(deleteAuthUserInfoBos)) {
            for (AuthUserInfoBo deleteAuthUserInfoBo : deleteAuthUserInfoBos) {
                SysCustInfoSubDo sysCustInfoSubDo = new SysCustInfoSubDo();
                sysCustInfoSubDo.setCustId(deleteAuthUserInfoBo.getCustId());
                sysCustInfoSubDo.setDelFlag("1");
                SysUserInfoDo sysUserInfoDo = new SysUserInfoDo();
                sysUserInfoDo.setUserId(deleteAuthUserInfoBo.getUserId());
                sysUserInfoDo.setDelFlag("1");
                sysUserInfoDo.setCustInfo(sysCustInfoSubDo);
                this.iSysUserInfoModel.modifyUserInfo(sysUserInfoDo);
                SysAuthDistributeDo sysAuthDistributeDo = new SysAuthDistributeDo();
                sysAuthDistributeDo.setUserId(deleteAuthUserInfoBo.getUserId());
                sysAuthDistributeDo.setDelFlag("1");
                this.iSysUserInfoModel.delUserRoleByUserId(sysAuthDistributeDo);
                SysUserTagRelSubDo sysUserTagRelSubDo = new SysUserTagRelSubDo();
                sysUserTagRelSubDo.setUserId(deleteAuthUserInfoBo.getUserId());
                sysUserTagRelSubDo.setDelFlag("1");
                this.iSysUserInfoModel.updateUserTag(sysUserTagRelSubDo);
            }
        }
    }

    private void dealAdd(List<AuthCustInfoBo> addAuthCustInfoBos, List<AuthUserInfoBo> addAuthUserInfoBos, List<AuthUserTagRelBo> addAuthUserTagRelBos, List<AuthDistributeBo> addAuthDistributeBos) {
        AuthCustInfoSyncReqBo authCustInfoSyncReqBo = new AuthCustInfoSyncReqBo();
        authCustInfoSyncReqBo.setCustInfoBos(addAuthCustInfoBos.stream().map(authCustInfoBo -> {
            SysCustInfoSubDo sysCustInfoSubDo = AuthRu.js(authCustInfoBo, SysCustInfoSubDo.class);
            sysCustInfoSubDo.setInitialPassword(this.initialPassword);
            return sysCustInfoSubDo;
        }).collect(Collectors.toList()));
        authCustInfoSyncReqBo.setUserInfoBos(AuthRu.jsl(addAuthUserInfoBos, SysUserInfoDo.class));
        addAuthUserTagRelBos.forEach(authUserTagRelBo -> authUserTagRelBo.setRelId(Long.valueOf(IdUtil.nextId())));
        authCustInfoSyncReqBo.setUserTagRelBos(AuthRu.jsl(addAuthUserTagRelBos, SysUserTagRelSubDo.class));
        addAuthDistributeBos.forEach(authDistributeBo -> authDistributeBo.setAuthId(Long.valueOf(IdUtil.nextId())));
        authCustInfoSyncReqBo.setAuthDistributeBos(AuthRu.jsl(addAuthDistributeBos, SysAuthDistributeDo.class));
        this.iSysUserInfoModel.addSyncCustInfo(authCustInfoSyncReqBo);
    }
}

