/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.commonmenu;

import com.tydic.dyc.authority.model.commonmenu.ISysCommonMenuModel;
import com.tydic.dyc.authority.model.commonmenu.qrybo.SysCommonMenuHistoryQryBo;
import com.tydic.dyc.authority.model.commonmenu.sub.SysCommonMenuHistorySubDo;
import com.tydic.dyc.authority.service.commonmenu.AuthSaveCommonMenuHistoryService;
import com.tydic.dyc.authority.service.commonmenu.bo.AuthSaveCommonMenuHistoryReqBo;
import com.tydic.dyc.authority.service.commonmenu.bo.AuthSaveCommonMenuHistoryRspBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.authority.utils.IdUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AUTHORITY_CENTER_DEV/2.0.0/com.tydic.dyc.authority.service.commonmenu.AuthSaveCommonMenuHistoryService"})
public class AuthSaveCommonMenuHistoryServiceImpl
implements AuthSaveCommonMenuHistoryService {
    @Autowired
    private ISysCommonMenuModel iSysCommonMenuModel;
    @Value(value="${COMMON_MENU_RECENT_MAX_SIZE:15}")
    private Integer MAX_SIZE;

    @PostMapping(value={"saveCommonMenuHistory"})
    public AuthSaveCommonMenuHistoryRspBo saveCommonMenuHistory(@RequestBody AuthSaveCommonMenuHistoryReqBo reqBo) {
        this.validateArg(reqBo);
        SysCommonMenuHistorySubDo subDo = AuthRu.js(reqBo, SysCommonMenuHistorySubDo.class);
        AuthSaveCommonMenuHistoryRspBo rspBo = AuthRu.success(AuthSaveCommonMenuHistoryRspBo.class);
        SysCommonMenuHistoryQryBo qryBo = new SysCommonMenuHistoryQryBo();
        qryBo.setUserId(reqBo.getUserId());
        List<SysCommonMenuHistorySubDo> sysCommonMenuHistorySubDoList = this.iSysCommonMenuModel.getCommonMenuHistoryList(qryBo).getSysCommonMenuHistorySubDoList();
        if (CollectionUtils.isEmpty(sysCommonMenuHistorySubDoList)) {
            subDo.setId(IdUtil.nextId());
            subDo.setCreateTime(new Date());
            this.iSysCommonMenuModel.saveCommonMenuHistory(subDo);
            return rspBo;
        }
        if (sysCommonMenuHistorySubDoList.stream().map(SysCommonMenuHistorySubDo::getMenuId).collect(Collectors.toList()).contains(reqBo.getMenuId())) {
            subDo.setId(((SysCommonMenuHistorySubDo)sysCommonMenuHistorySubDoList.stream().filter(item -> item.getMenuId().equals(reqBo.getMenuId())).collect(Collectors.toList()).get(0)).getId());
            subDo.setCreateTime(new Date());
            this.iSysCommonMenuModel.updateCommonMenuHistory(subDo);
            return rspBo;
        }
        if (sysCommonMenuHistorySubDoList.size() >= this.MAX_SIZE) {
            SysCommonMenuHistorySubDo delCountDo = new SysCommonMenuHistorySubDo();
            Integer delCount = sysCommonMenuHistorySubDoList.size() - this.MAX_SIZE + 1;
            delCountDo.setDelCount(delCount);
            delCountDo.setUserId(reqBo.getUserId());
            this.iSysCommonMenuModel.delExceedCommonMenuHistory(delCountDo);
        }
        subDo.setId(IdUtil.nextId());
        subDo.setCreateTime(new Date());
        this.iSysCommonMenuModel.saveCommonMenuHistory(subDo);
        return rspBo;
    }

    private void validateArg(AuthSaveCommonMenuHistoryReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthCreateApplicationReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

