/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.organization;

import com.tydic.dyc.authority.model.organization.ISysOrgInfoModel;
import com.tydic.dyc.authority.model.organization.SysOrgInfoDo;
import com.tydic.dyc.authority.model.organization.qrybo.SysOrgTagRelQryBo;
import com.tydic.dyc.authority.model.organization.sub.SysOrgTagRelSubDo;
import com.tydic.dyc.authority.service.organization.AuthModifyOrgTagService;
import com.tydic.dyc.authority.service.organization.bo.AuthModifyOrgTagReqBo;
import com.tydic.dyc.authority.service.organization.bo.AuthModifyOrgTagRspBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.authority.utils.IdUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AUTHORITY_CENTER_DEV/2.0.0/com.tydic.dyc.authority.service.organization.AuthModifyOrgTagService"})
public class AuthModifyOrgTagServiceImpl
implements AuthModifyOrgTagService {
    @Autowired
    private ISysOrgInfoModel iSysOrgInfoModel;

    @PostMapping(value={"modifyOrgTag"})
    public AuthModifyOrgTagRspBo modifyOrgTag(@RequestBody AuthModifyOrgTagReqBo reqBo) {
        this.validParam(reqBo);
        AuthModifyOrgTagRspBo rspBo = AuthRu.success(AuthModifyOrgTagRspBo.class);
        SysOrgTagRelQryBo orgTagRelQryBo = new SysOrgTagRelQryBo();
        orgTagRelQryBo.setOrgId(reqBo.getOrgId());
        SysOrgInfoDo sysOrgInfoDo = this.iSysOrgInfoModel.getOrgTagList(orgTagRelQryBo);
        List<SysOrgTagRelSubDo> orgTagRelSubDoList = sysOrgInfoDo.getOrgTagList();
        List<Object> orgTagIdList = new ArrayList();
        if (!CollectionUtils.isEmpty(orgTagRelSubDoList)) {
            orgTagIdList = orgTagRelSubDoList.stream().map(SysOrgTagRelSubDo::getTagId).collect(Collectors.toList());
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getAddOrgTagList())) {
            ArrayList<SysOrgTagRelSubDo> addTagList = new ArrayList<SysOrgTagRelSubDo>(reqBo.getAddOrgTagList().size());
            SysOrgInfoDo addReqBo = new SysOrgInfoDo();
            for (Long addOrgTagId : reqBo.getAddOrgTagList()) {
                if (orgTagIdList.contains(addOrgTagId)) continue;
                SysOrgTagRelSubDo addOrgTagRelSubDo = new SysOrgTagRelSubDo();
                addOrgTagRelSubDo.setOrgId(reqBo.getOrgId());
                addOrgTagRelSubDo.setTagId(addOrgTagId);
                addOrgTagRelSubDo.setTagStatus("1");
                addOrgTagRelSubDo.setRelId(IdUtil.nextId());
                addOrgTagRelSubDo.setDelFlag("0");
                addOrgTagRelSubDo.setCreateOperId(reqBo.getUpdateOperId());
                addOrgTagRelSubDo.setCreateOperName(reqBo.getUpdateOperName());
                addOrgTagRelSubDo.setCreateTime(reqBo.getUpdateTime());
                addOrgTagRelSubDo.setUpdateOperId(reqBo.getUpdateOperId());
                addOrgTagRelSubDo.setUpdateOperName(reqBo.getUpdateOperName());
                addOrgTagRelSubDo.setUpdateTime(reqBo.getUpdateTime());
                addTagList.add(addOrgTagRelSubDo);
            }
            addReqBo.setOrgTagList(addTagList);
            this.iSysOrgInfoModel.addOrgTagList(addReqBo);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getDeleteOrgTagList())) {
            ArrayList<SysOrgTagRelSubDo> deleteTagList = new ArrayList<SysOrgTagRelSubDo>(reqBo.getDeleteOrgTagList().size());
            SysOrgInfoDo deleteReqBo = new SysOrgInfoDo();
            for (Long deleteOrgTagId : reqBo.getDeleteOrgTagList()) {
                if (!orgTagIdList.contains(deleteOrgTagId)) continue;
                SysOrgTagRelSubDo deleteOrgTagRelSubDo = new SysOrgTagRelSubDo();
                deleteOrgTagRelSubDo.setUpdateOperId(reqBo.getUpdateOperId());
                deleteOrgTagRelSubDo.setUpdateOperName(reqBo.getUpdateOperName());
                deleteOrgTagRelSubDo.setUpdateTime(reqBo.getUpdateTime());
                deleteOrgTagRelSubDo.setDelFlag("1");
                deleteOrgTagRelSubDo.setTagId(deleteOrgTagId);
                deleteOrgTagRelSubDo.setOrgId(reqBo.getOrgId());
                deleteTagList.add(deleteOrgTagRelSubDo);
            }
            deleteReqBo.setOrgTagList(deleteTagList);
            this.iSysOrgInfoModel.updateOrgTagList(deleteReqBo);
        }
        return rspBo;
    }

    private void validParam(AuthModifyOrgTagReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getOrgId() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[orgId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

